# Equipment & Magic Items

## Currency

An average coin weighs less than half an ounce. A pouch of 50 coins weighs 1 pound.

### Table: Currency Conversion

| COIN          |    CP |   SP |    GP |      PP |
| ------------- | ----: | ---: | ----: | ------: |
| Copper (cp)   |     1 | 1/10 | 1/100 | 1/1,000 |
| Silver (sp)   |    10 |    1 |  1/10 |   1/100 |
| Gold (gp)     |   100 |   10 |     1 |    1/10 |
| Platinum (pp) | 1,000 |  100 |    10 |       1 |

## Equipment

### Armor

#### Calculating Armor Class (AC)

Wearing armor increases your armor class (AC), which in
turn increases your chance of avoiding enemy attacks. An
enemy's attack roll total must meet or beat your AC to deal
damage. So, the higher your AC, the greater your chance of
avoiding damage!

A typical PC who isn't wearing armor has an AC of 10 +
their DEX modifier.

When you wear armor, use the AC equation listed with the
type of armor you are wearing instead of the typical 10 +
DEX modifier equation. See the Armor table for an armor
type's AC equation as well as specific bonuses or limitations
it imposes when calculating AC.

#### Armor Types & Proficiencies

Armor types are categorized into three weights: light,
medium, or heavy. You need proficiency in a weight
of armor to use it well. For instance, a character with
proficiency in light armor can wear any type of armor listed
as light armor without penalty.

Your character can wear any kind of armor, regardless of
proficiency. However, if you don't have proficiency, you
have disadvantage on all STR and DEX ability checks made
while wearing it. You also can't cast spells while wearing
armor you aren't proficient with.

##### Light Armor

Light armor provides minimal protection while still
allowing its wearer to move with relative ease.

**_Padded._** This full-body outfit consists of quilted layers of
cloth and batting.

**_Leather._** The breastplate and shoulder protectors of this
armor are made of leather that has been stiffened by being
boiled in oil. The rest of the armor is made of softer and
more flexible materials.

**_Studded Leather._** Made from tough but flexible leather,
studded leather is reinforced with close-set rivets or spikes.

**_Brigandine._** This knee-length coat is made of heavy cloth
or canvas lined with small metal plates.

##### Medium Armor

Medium armor provides more protection than light armor,
but it uses bulkier materials that interfere with range of
motion.

**_Hide._** This full-body suit of armor consists of thick furs
and pelts.

**_Chain Shirt._** A chain shirt is made of interlocking metal
rings that are worn between layers of clothing or leather.
This armor protects the wearer's upper body and the
outer layers muffle the sound of the rings rubbing against
one another.

**_Scale Mail._** This armor consists of a coat and leggings
(and perhaps a separate skirt) of leather covered with
overlapping pieces of metal, much like the scales of a fish.

**_Breastplate._** This armor consists of a fitted metal
chest lined with supple leather. This armor leaves limbs
unprotected but provides good protection for vital organs
and allows for easier movement than most medium armor.

**_Half Plate._** Half plate consists of shaped metal plates
that cover most of the wearer's body. It doesn't include leg
protection beyond greaves attached with leather straps.

##### Heavy Armor

Heavy armor provides the most protection of any armor
type, but wearing it demands great physical prowess.

**_Ring Mail._** This leather armor has heavy rings sewn into
it. The rings help reinforce the armor against attacks.

**_Chain Mail._** This is a head-to-toe suit of armor made of
interlocking metal rings. Chain mail includes a layer of
quilted fabric worn underneath the mail to prevent chafing
and to cushion the impact of blows.

**_Splint._** This armor is made of narrow vertical strips of
metal riveted to a backing of leather that is worn over cloth
padding. Flexible chain mail protects the joints.

**_Plate._** Plate consists of shaped, interlocking metal plates
to cover the entire body. A suit of plate includes gauntlets,
heavy leather boots, a visored helmet, and thick layers
of padding underneath the armor. Buckles and straps
distribute the weight over the body.

##### Shields

A shield is handheld armor that is wielded instead of
worn. This means their AC bonus can be lost if the shield
is destroyed or becomes disarmed. Wielding a shield
requires the use of one hand, which means a PC can't use
two-handed weapons while holding a shield. You can only
benefit from one shield AC bonus at a time, even if you
wield multiple shields.

**_Shield._** This broad piece of wood and metal is held by a
handle attached to one side.

#### Getting Into and Out Of Armor

The time it takes to don (put on) or doff (take off) armor
depends on the armor's weight.

**_Don._** This is the time it takes to put on armor. You benefit
from the armor's AC only if you take the full time to don
the suit of armor.

**_Doff._** This is the time it takes to remove armor. If you have
help, halve this time, except for shields, which take 1 action
regardless of help.

##### Table: Donning and Doffing Armor

| CATEGORY     | DON        | DOFF      |
| ------------ | ---------- | --------- |
| Light Armor  | 1 minute   | 1 minute  |
| Medium Armor | 5 minutes  | 1 minute  |
| Heavy Armor  | 10 minutes | 5 minutes |
| Shield       | 1 action   | 1 action  |

#### Armor Tables

##### Table: Light Armor

| ARMOR           |  COST | ARMOR CLASS (AC)  | WEIGHT | PROPERTIES        |
| --------------- | ----: | ----------------- | -----: | ----------------- |
| Padded          |  5 gp | 11 + DEX modifier |  8 lb. | Noisy [^*]        |
| Leather         | 10 gp | 11 + DEX modifier | 10 lb. | Natural Materials |
| Studded leather | 45 gp | 12 + DEX modifier | 13 lb. | -                 |
| Brigandine      | 50 gp | 13 + DEX modifier | 25 lb. | Noisy             |

##### Table: Medium Armor

| ARMOR       |   COST | ARMOR CLASS (AC)          | WEIGHT | PROPERTIES        |
| ----------- | -----: | ------------------------- | -----: | ----------------- |
| Hide        |  10 gp | 12 + DEX modifier (max 2) | 12 lb. | Natural Materials |
| Chain Shirt |  50 gp | 13 + DEX modifier (max 2) | 20 lb. | -                 |
| Scale mail  |  50 gp | 14 + DEX modifier (max 2) | 45 lb. | Noisy             |
| Breastplate | 400 gp | 14 + DEX modifier (max 2) | 20 lb. | -                 |
| Half plate  | 750 gp | 15 + DEX modifier (max 2) | 40 lb. | Noisy             |

##### Table: Heavy Armor

| ARMOR      |     COST | ARMOR CLASS (AC) | WEIGHT | PROPERTIES                 |
| ---------- | -------: | ---------------: | -----: | -------------------------- |
| Ring mail  |    30 gp |               15 | 40 lb. | Noisy                      |
| Chain mail |    75 gp |               16 | 55 lb. | Cumbersome (STR 13), Noisy |
| Splint     |   200 gp |               17 | 60 lb. | Cumbersome (STR 15), Noisy |
| Plate      | 1,500 gp |               18 | 65 lb. | Cumbersome (STR 16), Noisy |

##### Table: Shield

| ARMOR  |  COST | ARMOR CLASS (AC) | WEIGHT | PROPERTIES |
| ------ | ----: | ---------------: | -----: | ---------- |
| Shield | 10 gp |               +2 |  6 lb. | - [^*]     |

[^*]: At the GM's discretion, this armor can have the Natural Materials property. Make this decision when you acquire it and note it on your character sheet.

#### Armor Properties

Many sets of armor have properties that affect their use, as
shown in the Properties column of the Armor table.

**_Cumbersome._** This armor is heavy and difficult to move
in unless you have the required STR score. If your STR
score doesn't equal or exceed the STR score listed in
parentheses, your movement speed is reduced by 10 feet
while you wear the armor, even if you're proficient with it.

**_Natural Materials._** This armor is made from materials
like wood, leather, or other organic materials. This renders
the item immune to the effects of spells like heat metal or
features like the rust monster's Antenna action.
Noisy. This armor imposes disadvantage on any ability
checks made to avoid notice, like sneaking, hiding, or
otherwise attempting to move silently.

### Weapons

#### Weapon Types & Proficiencies

Any character can wield any weapon, but only a character
with proficiency can add their PB to attack rolls with those
weapons.

##### Melee Weapons

Melee weapons are used to attack nearby targets within
reach. Unless the weapon has the Reach property, melee
weapons have a reach of 5 feet.

##### Ranged Weapons

Ranged weapons are used to attack targets at a distance.

##### Simple Weapons

Simple weapons require little experience to use effectively.

##### Martial Weapons

Martial weapons, including swords, axes, and polearms,
require training to use effectively.

#### Improvised Weapons

When in doubt about how much damage an object should
deal, find a weapon on the Weapons table most like the
object and use its damage die. For example, a table leg is a
lot like a club. At the GM's discretion, a character proficient
with a weapon can use a similar object as if it were that
weapon and add their PB as normal.

If a character uses a ranged weapon to make a melee
attack or throws a melee weapon that doesn't have the
Thrown property, those are improvised weapons, and
typically deal 1d4 damage of an appropriate damage type.
An improvised thrown weapon typically has range of 20
feet and a long range of 60 feet.

#### Weapon Options

This section offers options for using weapons in ways
other than dealing damage. The Weapon Option column
on the Weapons table shows which weapons can be used
to perform which weapon options. A character can use
a weapon option only if the character is wielding and is
proficient with an appropriate weapon.

**_Weapon Option Saves._** If an option requires a creature
to make an ability check or save, the DC equals 8 + the
attacker's PB + the attacker's STR or DEX modifier
(attacker's choice).

Unless specified otherwise, a weapon attack used to
perform a weapon option has only the option's listed effect
and doesn't deal normal weapon damage. Weapon options
can be used only when a wielder takes the Attack action
on their turn, unless a feature like the fighter's Martial
Action allows a weapon option attack to be performed as
a bonus action. Characters with the Multiattack feature
can perform a weapon option in place of one of the attacks
granted by Multiattack.

At the GM's discretion, some weapon options might
not work against certain creatures. For example, the trip
weapon option might not work against a creature without
discernable legs, such as an ooze, or that is anchored or
attached to the ground in some way, such as a tree with
animated limbs.

##### Bash

Make an attack roll with this weapon. On a hit, the target
has disadvantage on its next attack roll.

##### Disarm

Make an attack roll with this weapon. On a hit, the target
must succeed on a STR or DEX save (target's choice) or
drop a weapon, shield, or object it is wielding. The dropped
item lands in an unoccupied space within 5 feet of the
target. If no unoccupied space is within range, the item
lands at the target's feet.

##### Hamstring

Make an attack roll with this weapon. On a hit, the target's
base movement speed is reduced by 10 feet for 1 minute. A
creature's speed can't be reduced by more than 10 feet with
this weapon option. A creature within 5 feet of the target
can take an action to tend the wound with a successful
WIS (Medicine) check (against your weapon option DC),
ending the effect on the target. The effect also ends if the
target receives any magical healing.

##### Pinning Shot

Make an attack roll with this weapon against a Large or
smaller creature. On a hit, the target must succeed on a
STR or DEX save (target's choice) or its speed becomes 0
feet until the end of its next turn. A creature, including the
target, can use its action to attempt to free the target with
a STR (Athletics) check or a DEX (Acrobatics) check (the
creature's choice) versus the attacker's weapon option DC.
On a success, the target is freed and can move as normal.
A target must make only one check to free itself, using the
highest DC of characters performing this weapon option,
regardless of the number of arrows or bolts holding it in
place.

##### Pull

Make an attack roll with this weapon against a Large or
smaller creature. On a hit, the target is pulled up to 5 feet
closer to you. If this movement would pull a creature into
damaging terrain, such as lava or a pit, it can make a STR
or DEX (target's choice) save to avoid the pull on a success.

##### Ricochet Shot

Make an attack roll with this weapon against a target you
can see that has half or three-quarters cover. Your chosen
target must be within 10 feet of another object or structure
that isn't the same item providing it with cover. When you
do so, you can treat the target's AC as if it wasn't behind
cover. If the attack is successful, the target takes damage
from the attack as it would with a standard weapon attack.
This weapon option expends the same ammunition as a
normal attack with this weapon.

##### Trip

Make an attack roll with this weapon against a Large or
smaller creature. On a hit, the target must succeed on
a STR or DEX save (target's choice) or fall prone. If the
target is mounted, it has advantage on the save.

#### Weapon Properties

Many weapons have special properties that affect their use,
as shown in the Properties column of the Weapons table.

**_Ammunition._** You can use a weapon that has the
Ammunition property to make a ranged attack only if you
have ammunition to fire from it. Each time you attack
with the weapon, you expend one piece of ammunition.
You need a free hand to load a one-handed weapon, and
drawing the ammunition from a quiver, case, or other
container is part of the attack. At the end of an encounter,
you can recover half your expended ammunition by taking
1 minute to search the battlefield.

If you use a weapon with the Ammunition property to
make a melee attack, treat it as an improvised weapon.
A sling must be loaded to deal damage when used as an
improvised weapon.

**_Finesse._** When making an attack with a Finesse weapon,
use your choice of your STR or DEX modifier for the
attack and damage rolls. You must use the same modifier
for both rolls.

**_Heavy._** Small creatures have disadvantage on attack rolls
with Heavy weapons. Tiny creatures can't wield Heavy
weapons.

**_Light._** A Light weapon is needed for use with two-weapon
fighting.

**_Loading._** Because of the time required to load this
weapon, you can fire only one piece of ammunition from it
when you use an action, bonus action, or reaction to fire it,
regardless of the number of attacks you can normally make.

**_Range._** A weapon that can be used to make a ranged
attack has a range in parentheses after the Ammunition
or Thrown property. The range lists two numbers. The
first is the weapon's normal range in feet, and the second
indicates the weapon's long range. When attacking a target
beyond normal range and up to its long range, you have
disadvantage on the attack roll. You can't attack a target
beyond the weapon's long range.

**_Reach._** This weapon adds 5 feet to your reach when you
make melee attacks with it, as well as when determining
your reach for opportunity attacks with it.

**_Special (Lance)._** You have disadvantage when you use a
lance to attack a target within 5 feet of you. Also, a lance
requires two hands to wield when you aren't mounted.

**_Thrown._** You can throw a weapon with the Thrown
property to make a ranged attack. If the weapon can also
be a melee weapon, use the same ability modifier for that
attack roll and damage roll that you would use for a melee
attack with the weapon. For example, if you throw a
handaxe or javelin, use your STR modifier, but if you throw
a dagger, you can use either your STR or DEX modifier,
since the dagger has the Finesse property.

**_Two-Handed._** This weapon requires you to use two hands
when you attack with it.

**_Versatile._** This weapon can be used with one or two hands.
These weapons have two damage values listed. The higher
damage value is used when you use two hands to make a
melee weapon attack.

#### Weapons Tables

##### Table: Simple Melee Weapons

| WEAPON       | COST | DAMAGE              | WEIGHT | WEAPON OPTION | PROPERTIES                               |
| ------------ | ---: | ------------------- | -----: | ------------- | ---------------------------------------- |
| Club         | 1 sp | 1d4 bludgeoning     |  2 lb. | Bash          | Light                                    |
| Dagger       | 2 gp | 1d4 piercing        |  1 lb. | Pinning Shot  | Finesse, Light, Thrown (range 20/60 ft.) |
| Greatclub    | 2 sp | 1d8 bludgeoning     | 10 lb. | Bash          | Two-handed                               |
| Handaxe      | 5 gp | 1d6 slashing        |  2 lb. | Hamstring     | Light, Thrown (range 20/60 ft.)          |
| Javelin      | 5 sp | 1d6 piercing        |  2 lb. | Pinning Shot  | Thrown (range 30/120 ft.)                |
| Light hammer | 2 sp | 1d4 bludgeoning     |  2 lb. | Bash          | Light, Thrown (range 20/60 ft.)          |
| Mace         | 5 gp | 1d6 bludgeoning     |  4 lb. | Bash          | -                                        |
| Quarterstaff | 2 sp | 1d6/1d8 bludgeoning |  4 lb. | Bash          | Versatile                                |
| Sickle       | 1 gp | 1d4 slashing        |  2 lb. | Hamstring     | Light                                    |
| Spear        | 1 gp | 1d6/1d8 piercing    |  3 lb. | Pull, Trip    | Reach, Versatile      |

##### Table: Simple Ranged Weapons

| WEAPON          |  COST | DAMAGE               | WEIGHT | WEAPON OPTION | PROPERTIES                                         |
| --------------- | ----: | -------------------- | -----: | ------------- | -------------------------------------------------- |
| Crossbow, light | 25 gp | 1d8 piercing         |  5 lb. | -             | Ammunition (range 80/320 ft.), Loading, Two-handed |
| Dart            |  5 cp | 1d4 piercing 1/4 lb. |      - | -             | Finesse, Thrown (range 20/60 ft.)                  |
| Shortbow        | 25 gp | 1d6 piercing         |  2 lb. | -             | Ammunition (range 80/320 ft.), Two-handed          |
| Sling           |  1 sp | 1d4 bludgeoning      |      - | Ricochet Shot | Ammunition (range 30/120 ft.)                      |

##### Table: Martial Melee Weapons

| WEAPON      |  COST | DAMAGE               | WEIGHT | WEAPON OPTION     | PROPERTIES                          |
| ----------- | ----: | -------------------- | -----: | ----------------- | ----------------------------------- |
| Battleaxe   | 10 gp | 1d8/1d10 slashing    |  4 lb. | Disarm, Hamstring | Versatile                           |
| Flail       | 10 gp | 1d8 bludgeoning      |  2 lb. | Bash, Disarm      | -                                   |
| Glaive      | 20 gp | 1d10 slashing        |  6 lb. | Trip              | Heavy, Reach, Two-handed            |
| Greataxe    | 30 gp | 1d12 slashing        |  7 lb. | Disarm, Hamstring | Heavy, Two-handed                   |
| Greatsword  | 50 gp | 2d6 slashing         |  6 lb. | Disarm, Hamstring | Heavy, Two-handed                   |
| Halberd     | 20 gp | 1d10 slashing        |  6 lb. | Trip              | Heavy, Reach, Two-handed            |
| Lance       | 10 gp | 1d12 piercing        |  6 lb. | -                 | Reach, Special                      |
| Longsword   | 15 gp | 1d8/1d10 slashing    |  3 lb. | Disarm, Hamstring | Versatile                           |
| Maul        | 10 gp | 2d6 bludgeoning      | 10 lb. | Bash, Disarm      | Heavy, Two-handed                   |
| Morningstar | 15 gp | 1d8 piercing         |  4 lb. | Disarm            | -                                   |
| Pike        |  5 gp | 1d10 piercing        | 18 lb. | Trip              | Heavy, Reach, Two-handed            |
| Rapier      | 25 gp | 1d8 piercing         |  2 lb. | Disarm            | Finesse                             |
| Scimitar    | 25 gp | 1d6 slashing         |  3 lb. | Hamstring         | Finesse, Light                      |
| Scythe      | 20 gp | 2d4 slashing         |  4 lb. | Pull, Trip        | Reach, Two-handed                   |
| Shortsword  | 10 gp | 1d6 piercing         |  2 lb. | Disarm            | Finesse, Light                      |
| Trident     |  5 gp | 1d6/1d8 piercing     |  4 lb. | Disarm            | Thrown (range 20/60 ft.), Versatile |
| War pick    |  5 gp | 1d8 piercing         |  2 lb. | Disarm            | -                                   |
| Warhammer   | 15 gp | 1d8/1d10 bludgeoning |  2 lb. | Bash, Disarm      | Versatile                           |
| Whip        |  2 gp | 1d4 slashing         |  3 lb. | Pull, Trip        | Finesse, Reach                      |

##### Table: Martial Ranged Weapons

| WEAPON          |  COST | DAMAGE        | WEIGHT | WEAPON OPTION | PROPERTIES                                                 |
| --------------- | ----: | ------------- | -----: | ------------- | ---------------------------------------------------------- |
| Blowgun         | 10 gp | 1 piercing    |  1 lb. | -             | Ammunition (range 25/100 ft.), Loading                     |
| Crossbow, hand  | 75 gp | 1d6 piercing  |  3 lb. | Pinning Shot  | Ammunition (range 30/120 ft.), Light, Loading              |
| Crossbow, heavy | 50 gp | 1d10 piercing | 18 lb. | Pinning Shot  | Ammunition (range 100/400 ft.), Heavy, Loading, Two-handed |
| Longbow         | 50 gp | 1d8 piercing  |  2 lb. | Pinning Shot  | Ammunition (range 150/600 ft.), Heavy, Two-handed          |



#### Special Gear

**_Acid._** As an action, you can splash the contents of this vial
onto a creature within 5 feet of you or throw the vial up
to 20 feet, shattering it on impact. In either case, make a
ranged attack against a creature or object, treating the acid
as an improvised weapon. On a hit, the target takes 2d6
acid damage.

**_Alchemist's Fire._** This sticky, adhesive fluid ignites when
exposed to air. As an action, you can throw this flask up
to 20 feet, shattering it on impact. Make a ranged attack
against a creature or object, treating the alchemist's fire
as an improvised weapon. On a hit, the target takes 1d4
fire damage at the start of each of its turns. A creature can
end this damage by using its action to make a DC 10 DEX
(Sleight of Hand) check to extinguish the flames.

**_Antitoxin._** A creature that drinks this vial of liquid gains
advantage on saves against poison for 1 hour. It confers no
benefit to Undead or Constructs.
Arcane Focus. This item can be used as a spellcasting
focus to channel Arcane spells. Examples include an orb, a
crystal, a rod, a specially made staff, or a wooden wand.

**_Ball Bearings._** As an action, you can spill these tiny metal
balls from their pouch to cover a level, square area, 10 feet
on a side. A creature moving in this area must succeed on
a DC 10 DEX save or fall prone. A creature moving in the
area at half speed doesn't need to make the save.

**_Block and Tackle._** This is a set of pulleys with a cable
threaded through them and a hook to attach to items. A
block and tackle allows you to hoist up to four times the
weight you can normally lift.

**_Book._** A book might contain poetry, historical accounts,
information pertaining to a field of lore, diagrams, notes
on contraptions, or just about anything that can be
represented using text or pictures. A spellbook is a separate
item described later in this section.

**_Caltrops._** As an action, you can spread a bag of caltrops
to cover a 5-foot-square area. A Large or smaller creature
that enters the area must succeed on a DC 15 DEX save or
stop moving this turn and take 1 piercing damage. Taking
this damage reduces the creature's walking speed by 10 feet
until the creature regains at least 1 hit point. A creature
moving through the area at half speed doesn't need to
make the save.

**_Candle._** For 1 hour, a candle sheds bright light in a 5-foot
radius and dim light for an additional 5 feet.
Case, Map or Scroll. This cylindrical leather case can hold
up to ten rolled-up sheets of paper.

**_Chain._** A chain is an object that has AC 20 and 10 HP. It
can be broken as an action with a successful DC 20 STR
(Athletics) check.

**_Climber's Kit._** A climber's kit includes special pitons, boot
tips, gloves, and a harness. You can use the climber's kit as
an action to anchor yourself to a solid surface within 5 feet
of you (this surface can't be part of a creature); when you
do, you can't fall more than 25 feet from your anchor point,
and you can't climb more than 25 feet away from that point
without undoing the anchor.

**_Component Pouch._** A component pouch is a small,
watertight leather belt pouch that has compartments to
hold all the material components and other special items
you need to cast your spells, except for those material
components that have a listed gp cost (as indicated in a
spell's description).

**_Crowbar._** Using a crowbar grants advantage to STR
checks where the crowbar's leverage can be applied.
Fishing Tackle. This kit includes a wooden rod, silken line,
corkwood bobbers, iron hooks, lead sinkers, velvet lures,
and netting.

**_Healer's Kit._** This kit is a leather pouch containing
bandages, salves, and splints. The kit has 10 uses. As an
action, you can expend one use of the kit to stabilize a
creature that has 0 HP without needing to make a WIS
(Medicine) check.

**_Holy Symbol._** This item can be used as a spellcasting focus
to channel Divine spells. Examples include an amulet
depicting a deity's symbol, that same symbol engraved or
inlaid as an emblem on a shield, or a tiny box holding a
fragment of a sacred relic.

**_Holy Water._** As an action, you can splash the contents of
this flask onto a creature within 5 feet of you or throw the
flask up to 20 feet, shattering it on impact. In either case,
make a ranged attack against a target creature, treating the
holy water as an improvised weapon. If the target is a Fiend
or Undead, it takes 2d6 radiant damage-otherwise, the
water has no effect.
A creature that can cast at least one 1st-circle Divine
spells can create holy water by performing a special ritual.
The ritual takes 1 hour to perform, uses 25 gp worth of
powdered silver, and requires the caster to expend a 1st ircle spell slot.

**_Hunting Trap, Basic._** As an action, you can set a trap in
an unoccupied space within 5 feet of you. When set, this
trap forms a saw-toothed steel ring that snaps shut when a
creature steps on a pressure plate in the center. A Large or
smaller creature that enters the trap's space must succeed
on a DC 13 DEX save or take 1d4 piercing damage and
become grappled until freed. A creature can use its action
to make a DC 13 STR (Athletics) check, freeing itself or
another creature within its reach on a success. Each failed
check deals 1 piercing damage to the trapped creature.

**_Lamp._** While lit, a lamp casts bright light in a 15-foot
radius and dim light for an additional 30 feet. Once lit, it
burns for 6 hours on a flask (1 pint) of oil.

**_Lantern, Bullseye._** While lit, a bullseye lantern casts bright
light in a 60-foot cone and dim light for an additional 60
feet. Once lit, it burns for 6 hours on a flask (1 pint) of oil.

**_Lantern, Hooded._** While lit, a hooded lantern casts bright
light in a 30-foot radius and dim light for an additional 30
feet. Once lit, it burns for 6 hours on a flask (1 pint) of oil.
As an action, you can lower the hood, reducing the light to
dim light in a 5-foot radius.

**_Lock._** A key is provided with the lock. Without the key,
a creature proficient with thieves' tools can pick this lock
with a successful DC 15 DEX (Thieves' Tools) check. Your
GM can decide that better locks are available for higher
prices.

**_Magnifying Glass._** This lens allows a closer look at small
items. It is also useful as a substitute for flint and steel
when starting fires. Lighting a fire with a magnifying glass
requires sunlight to focus, tinder to light, and about 5
minutes for the fire to ignite. A magnifying glass grants
advantage on any ability check made to appraise or inspect
an item that is small or highly detailed.

**_Manacles._** These metal restraints can bind a Small or
Medium creature. To escape the manacles, a creature must
use their action to make a successful DC 20 DEX (Sleight
of Hand) check or break them with a successful DC 20 STR
(Athletics) check. Each set of manacles comes with one key.
Without the key, a creature proficient with thieves' tools
can pick the manacles' lock with a successful DC 15 DEX
(Thieves' Tools) check. Manacles are an object that has AC
19 and 15 HP.

**_Mess Kit._** This tin box contains a cup and simple cutlery.
The box clamps together; one side can be used as a cooking
pan and the other as a plate or shallow bowl.

**_Net._** As an action, you can throw a net at a Large or
smaller creature within 15 feet of you. The net has no effect
on creatures that are formless or incorporeal (like ghosts).
Make a ranged attack against the creature, treating the net
as an improvised weapon. On a hit, the target is restrained
until it is freed. A creature can use its action to make a DC
10 STR (Athletics) check, freeing itself or another creature
within its reach on a success. Dealing 5 slashing damage to
the net (AC 10) also frees the creature without harming it,
ending the effect and destroying the net.

**_Oil._** Oil usually comes in a clay flask that holds 1 pint. As
an action, you can splash oil onto a creature within 5 feet of
you or throw the flask up to 20 feet, shattering on impact.
Make a ranged attack against a target creature or object,
treating the oil as an improvised weapon. On a hit, the
target is covered in oil. If the target takes any fire damage
before the oil dries (after 1 minute), the target takes an
additional 5 fire damage from the burning oil. You can also
pour a flask of oil on the ground to cover a 5-foot-square
area, provided that the surface is level. If lit, the oil burns
for 2 rounds and deals 5 fire damage to any creature that
enters the area or ends its turn in the area. A creature can
take this damage only once per turn.

**_Poison, Basic (Injury)._** You can use the poison in this vial
to coat one weapon or up to three pieces of ammunition
that deal piercing or slashing damage. Applying the poison
takes an action. A creature hit by the poisoned weapon or
ammunition must succeed on a DC 10 CON save or take
1d4 poison damage (in addition to the weapon's normal
damage). Once applied, the poison retains potency for 1
minute before drying.

**_Poison, Essence of Ether (Inhaled)._** A creature subjected
to this poison must succeed on a DC 15 CON save
or be poisoned for 8 hours. The poisoned creature is
unconscious. The unconscious effect ends if the creature
takes damage or if another creature takes an action to
shake it awake.

**_Poison, Last Gasp (Contact)._** A creature subjected to this
poison must succeed on a DC 13 CON save or be poisoned
for 1 minute. The poisoned creature is paralyzed. The
creature can repeat the save at the end of each of its turns,
ending both effects on a success.

**_Poison, Midnight Tears (Ingested)._** A creature who ingests
this poison suffers no effect until the stroke of midnight.
If the poison has not been neutralized before then, the
creature must succeed on a DC 17 CON save, taking 31
(9d6) poison damage on a failure or half as much damage
on a success.

**_Potion of Healing._** A character who drinks the magical
red fluid in this vial regains 2d4 + 2 hit points. Drinking
or administering a potion takes an action. For more
information about this item, see potion of healing in the
Magic Item Descriptions.

**_Pouch._** A cloth or leather pouch can hold up to 20 sling
bullets or 50 blowgun needles, among other things. A
compartmentalized pouch for holding spell components is
called a component pouch (described earlier in this section).

**_Primordial Focus._** This item can be used as a spellcasting
focus to channel Primordial spells. Examples include a
totem made from natural materials like feather or bone, a
wooden staff carved from a living tree, or a yew wand.

**_Quiver._** A quiver can hold up to 20 arrows or 20 crossbow
bolts.

**_Ram, Portable._** You can use a portable ram to break down
doors. You have advantage on relevant STR (Athletic)
checks made to do so.

**_Rations._** Rations consist of dry foods suitable for
extended travel, including jerky, dried fruit, hardtack, and
nuts. One unit of rations is enough to feed one Medium or
smaller creature for one day.

**_Rope._** Rope is an object with AC 11 and 2 HP. It can be
burst with a DC 17 STR (Athletics) check.
Scale, Merchant's. A scale includes a small balance, pans,
and a suitable assortment of weights up to 2 lb. With it, you
can measure the exact weight of suitably sized objects, such
as raw precious metals or trade goods, to help determine
their worth.

**_Spellbook._** A spellbook is a leather‑bound tome with 100
blank pages suitable for recording spells.
Spyglass. Objects viewed through a spyglass are magnified
to twice their size. A spyglass grants advantage on any
ability check made to view or inspect items that are far away.

**_Tent._** A simple, portable canvas shelter that sleeps two
Medium or smaller creatures.

**_Tinderbox._** This small container holds flint, fire steel, and
tinder (usually dry cloth soaked in light oil) used to kindle
a fire. Using it to light a torch-or anything else with
abundant, exposed fuel-takes an action. Lighting any
other fire takes 1 minute.

**_Torch._** A torch burns for 1 hour, providing bright light in
a 20-foot radius and dim light for an additional 20 feet. If
you make a melee attack with a burning torch and hit, it
deals 1 fire damage.

**_Wyrd Focus._** This item can be used as a spellcasting focus
to channel Wyrd spells. Examples include an amulet carved
from bone, a charm bag filled with rare herbs and crystals,
or a wand made of starmetal.

### Adventuring Gear

#### Table: Adventuring Gear

| GEAR                              |     COST |    WEIGHT |
| --------------------------------- | -------: | --------: |
| Abacus                            |     2 gp |     2 lb. |
| _Alchemical Concoctions_          |          |           |
| Acid (vial)                       |    25 gp |     1 lb. |
| Alchemist’s fire (flask)          |    50 gp |     1 lb. |
| Oil (flask)                       |     1 sp |     1 lb. |
| _Ammunition_                      |          |           |
| Arrows (20)                       |     1 gp |     1 lb. |
| Blowgun needles (50)              |     1 gp |     1 lb. |
| Crossbow bolts (20)               |     1 gp | 1 1/2 lb. |
| Sling bullets (20)                |     4 cp | 1 1/2 lb. |
| Ball bearings (bag of 1,000)      |     1 gp |     2 lb. |
| Bedroll                           |     1 gp |     7 lb. |
| Bell                              |     1 gp |         - |
| Blanket                           |     5 sp |     3 lb. |
| Block and tackle                  |     1 gp |     5 lb. |
| Book                              |    25 gp |     5 lb. |
| Caltrops (bag of 20)              |     1 gp |     2 lb. |
| Candle                            |     1 cp |         - |
| Case, map or scroll               |     1 gp |     1 lb. |
| Chain (10 feet)                   |     5 gp |    10 lb. |
| Chalk (1 piece)                   |     1 cp |         - |
| Climber’s kit                     |    25 gp |    12 lb. |
| Clothes, common                   |     5 sp |     3 lb. |
| Clothes, costume                  |     5 gp |     4 lb. |
| Clothes, fine                     |    15 gp |     6 lb. |
| Component pouch                   |    25 gp |     2 lb. |
| _Containers_                      |          |           |
| - Backpack                        |     2 gp |     5 lb. |
| - Barrel                          |     2 gp |    70 lb. |
| - Basket                          |     4 sp |     2 lb. |
| - Bottle, glass                   |     2 gp |     2 lb. |
| - Chest                           |     5 gp |    25 lb. |
| - Flask or tankard                |     2 cp |     1 lb. |
| - Jug or pitcher                  |     2 cp |     4 lb. |
| - Pot, cooking                    |     2 gp |    10 lb. |
| - Pouch                           |     5 sp |     1 lb. |
| - Sack                            |     1 cp |   1/2 lb. |
| - Vial                            |     1 gp |         - |
| - Waterskin (full)                |     2 sp |     5 lb. |
| Crowbar                           |     2 gp |     5 lb. |
| Fishing tackle                    |     1 gp |     4 lb. |
| Hammer                            |     1 gp |     3 lb. |
| Healer’s kit                      |     5 gp |     3 lb. |
| _Herbal Concoctions_              |          |           |
| - Antitoxin (vial)                |    50 gp |         - |
| - Perfume (vial)                  |     5 gp |         - |
| - Poison, basic (vial)            |     5 gp |         - |
| - Poison, essence of ether (vial) |   300 gp |         - |
| - Poison, last gasp (vial)        |   200 gp |         - |
| - Poison, midnight tears (vial)   | 1,500 gp |         - |
| Holy water (flask)                |    25 gp |     1 lb. |
| Hourglass                         |    25 gp |     1 lb. |
| Hunting trap, basic               |     5 gp |    25 lb. |
| Ink (1-ounce bottle)              |    10 gp |         - |
| Ink pen                           |     2 cp |         - |
| Ladder (10-foot)                  |     1 sp |    25 lb. |
| Lamp                              |     5 sp |     1 lb. |
| Lantern, bullseye                 |    10 gp |     2 lb. |
| Lantern, hooded                   |     5 gp |     2 lb. |
| Lock                              |    10 gp |     1 lb. |
| Magnifying glass 1                |    00 gp |         - |
| Manacles                          |     2 gp |     6 lb. |
| Mess kit                          |     2 sp |     1 lb. |
| Mirror, compact                   |     5 gp |   1/2 lb. |
| Net                               |     1 gp |     3 lb. |
| Paper (one sheet)                 |     2 sp |         - |
| Pick, miner’s                     |     2 gp |    10 lb. |
| Piton                             |     5 cp |   1/4 lb. |
| Pole (10-foot)                    |     5 cp |     7 lb. |
| Potion of healing                 |    50 gp |   1/2 lb. |
| Quiver                            |     1 gp |     1 lb. |
| Ram, portable                     |     4 gp |    35 lb. |
| Rations (1 day)                   |     5 sp |     2 lb. |
| Rope (50 feet)                    |     1 gp |    10 lb. |
| Sealing wax                       |     5 sp |         - |
| Scale, merchant’s                 |     5 gp |     3 lb. |
| Shovel                            |     2 gp |     5 lb. |
| Signal whistle                    |     5 cp |         - |
| Signet ring                       |     5 gp |         - |
| Soap                              |     2 cp |         - |
| Spellbook                         |    50 gp |     3 lb. |
| _Spellcasting Foci_               |          |           |
| - Arcane focus                    |     5 gp |     2 lb. |
| - Holy symbol                     |     5 gp |     2 lb. |
| - Primordial focus                |     5 gp |     2 lb. |
| - Wyrd focus                      |     5 gp |     2 lb. |
| Spikes, iron (10)                 |     1 gp |     5 lb. |
| Spyglass                          | 1,000 gp |     1 lb. |
| Tent, two-person                  |     2 gp |    20 lb. |
| Tinderbox                         |     5 sp |     1 lb. |
| Torch                             |     1 cp |     1 lb. |
| Whetstone                         |     1 cp |     1 lb. |

### Table: Container Capacity

| CONTAINER                 | VOLUME CAPACITY            | WEIGHT CAPACITY |
| ------------------------- | -------------------------- | --------------: |
| Backpack                  | 1 cubic foot               |          30 lb. |
| Barrel                    | 4 cubic feet or 40 gallons |         300 lb. |
| Basket                    | 2 cubic feet               |          40 lb. |
| Bottle, flask, or tankard | 1 pint                     |           1 lb. |
| Chest                     | 12 cubic feet              |         300 lb. |
| Jug, pitcher, or pot      | 1 gallon                   |           8 lb. |
| Pouch                     | 1/5 cubic foot             |           6 lb. |
| Sack                      | 1 cubic foot               |         30 lb., |
| Vial                      | 4 oz                       |         1/4 lb. |
| Waterskin                 | 4 pints                    |           4 lb. |

### Tools

Sometimes a tool is a single item, like a musical
instrument. Other times a tool encompasses a kit or set of
supplies containing multiple items. When using a tool, you
must have all of its component items to make ability checks
with it.

Just like skills, you don't need to be proficient in a tool to
use it, but proficiency with a tool allows you to add your PB
to ability checks you make using that tool.

Also, like skills, tools aren't tied to specific ability scores.
The ability score assigned to each ability check using a
tool depends on what you are trying to accomplish. For
example, when using construction tools, the GM might
ask you to make a STR (Construction Tools) check to
hammer nails into a hard surface, but ask for a DEX
(Construction Tools) check to use the same tools to carve a
wooden sculpture.

#### Alchemist Tools

Alchemist tools are used to perform a variety of tasks
such as identifying potions or foreign substances, mixing
reagents together to cause alchemical reactions, and
crafting alchemical substances.

**_Associated Abilities:_** DEX, INT.

**_Components._** This tool kit includes an array of mixing and
storage vessels, an alembic still, a metal frame for holding
a mixing vessel above a flame, a mortar and pestle, and a
variety of common alchemical reagents.

**_Craft Items._** Alchemist tools can be used to make items like
those listed in the Alchemical Concoctions section of the
Adventuring Gear table, with the crafting downtime
activity.

#### Artist Tools

Artist tools are used to create illustrated art objects and
ornamental documents, pen illuminated texts, and
skillfully paint objects.

**_Associated Abilities:_** DEX, CHA.

**_Components._** This tool kit includes brushes, spades, stirrers,
inks, paints, a square and triangle, a canvas stretcher and
an easel, and rolls of vellum, parchment, and canvas.

**_Craft Items._** Artist tools can be used to make art objects
with the crafting downtime activity.

#### Charlatan Tools

Charlatan tools are used to craft disguises and forge
documents.

**_Associated Abilities:_** DEX, CHA.

**_Components._** This tool kit includes hair dyes, small props,
cosmetics, a few choice articles of clothing, a selection
of wax seals, gold and silver leaf, inks, a variety of
parchments, and sculpting tools to fashion melted wax
into seals or prosthetics.

**_Create Disguise._** Over the course of an hour (which can be
done as part of a rest) you can create a disguise to make
yourself or someone else-including any clothing or
equipment-look like a different creature. A disguise can
make a creature seem slightly taller, shorter, fatter, or
thinner, but can't conceal true size or basic arrangement
of limbs. It takes 1 minute to don such a disguise once
created. A set of charlatan tools only has enough materials
to create one disguise at a time, but you can disassemble
a disguise to create a new disguise as part of the time
spent making a disguise. A creature can use its action to
inspect a disguised appearance, and must succeed on an
INT (Investigation) contest versus your DEX (Charlatan
Tools) to discern a disguise.

**_Forge Documents._** Over the course of one hour (which can
be done as part of a rest) you can create a simple false
document of 5 pages or less-like a personal letter, a party
invitation, or a sales permit. With the GM's permission
you can create longer or more complicated documents
over the course of several hours or days. A creature can
use its action to inspect a forged document, and must
succeed on an INT (Investigation) contest versus your
DEX (Charlatan Tools) check to discern a forgery.

#### Clothier Tools

Clothier tools are used to sew, make, or tailor fabric objects
such as clothing or shoes.

**_Associated Abilities:_** DEX, CHA.

**_Components._** This tool kit includes pins and needles,
specially sharpened shears, a small hammer and shoe
horn, a variety of dyed threads on spools, and thicker
waxed threads and yarns.

**_Craft Items._** Clothier tools can be used to make items with
the crafting downtime activity.

#### Construction Tools

Construction tools are used to build and repair items
primarily made of wood or stone.

**_Associated Abilities:_** STR, DEX.

**_Components._** This tool kit includes hammers and a mallet,
a variety of fasteners, a square and triangle, chisels, a saw,
brushes, and spades.

**_Fortify._** You can spend 1 minute fortifying a chest, door,
window, or other sealable object or structure. When you
do so, the object's AC increases by an amount equal to
your PB or creatures have disadvantage on STR (Athletics)
checks made to penetrate the fortification (the GM
decides which is more relevant). An item doesn't receive
additional benefits from multiple attempts to fortify it.

**_Build Cover._** You can spend 1 hour (which can be done as
part of a long rest) erecting a 5-foot by 5-foot wall panel
in an unoccupied space, provided you have the raw
materials to do so. The panel provides three-quarters
cover for one Medium or smaller creature, and it can't
be moved. A panel of cover created with this feature is
an object with an AC equal to 10 + your PB and 15 HP if
made of wood or 25 HP if made of stone. It is immune to
psychic and poison damage.

**_Craft Items._** Construction tools can be used to make items
with the crafting downtime activity.

#### Gaming Set

Gaming sets are used to gamble, entertain, or engage in
fortune-telling. There are three types: cards, dice, and
board games. When you have proficiency in a gaming set,
choose one type for your proficiency, not all gaming sets.
You must have multiple proficiencies to have proficiency
with more than one type of gaming set.

**_Associated Abilities:_** DEX, CHA.

**_Components._** A gaming set is typically a full set of cards, a
full set of dice with a dice cup, or a collection of special
pieces used to play a particular game. If you are unsure
what to choose, consult your GM about games and game
sets played in the world of your game.

#### Herbalist Tools

Herbalist tools are used to store and brew plants and other
organic materials into potions, antidotes, and poisons.

**_Associated Abilities:_** INT, WIS.

**_Components._** This tool kit includes glass vials, a mortar and
pestle, pouches for ingredient storage, clippers, a pair of
leather gloves, and a small pot for brewing.

**_Craft Items._** Herbalist tools can be used to make items like
those listed in the Herbal Concoctions section of the
Adventuring Gear table, with the crafting downtime
activity.

#### Musical Instrument

Musical instruments come in many shapes and sizes
with varying regional and cultural popularity. When you
have proficiency in a musical instrument, choose one
type: strings, brass, woodwinds, percussion, or keyboard
instruments. You must have multiple proficiencies to have
proficiency with more than one type of instrument.

**_Associated Abilities:_** DEX, CHA.

**_Components._** A musical instrument typically includes
an instrument, a protective case, and any small pieces
necessary for play, such as picks or reeds.

#### Navigator Tools

Navigator tools are used to read and draw maps, find your
path or prevent you from becoming lost, and determine
likely locations on a map for secret doors or hidden features.

**_Associated Abilities:_** INT, WIS.

**_Components._** This tool kit includes quills, ink, and
parchment along with two compasses, calipers, and a ruler
as well as a sextant or telescope.

**_Draw Map._** Navigator tools can be used to create accurate
maps while traveling, which grant advantage on checks
made to prevent becoming lost.

#### Provisioner Tools

Provisioner tools are used to prepare meals, make rations,
and craft beverages.

**_Associated Abilities:_** CON, WIS.

**_Components._** This tool kit includes a large jug, several jars,
a siphon with several feet of tubing, a rolled set of knives
for chopping, sawing, paring, and deboning, a metal soup
pot and a large skillet, a small bundle of spoons, spatulas,
ladels, and whisks, several mixing bowls, a cutting board,
and quantities of hops, dried herbs, and powdered spices.

**_Craft Items._** Provisioner tools can be used to make items
with the crafting downtime activity.

#### Smithing Tools

Smithing tools are used to build and repair items primarily
made of metal. The use of smithing tools typically requires
a dedicated forge, furnace, or some other source of intense
heat. A campfire is only suitable for the smallest tasks like
spot repairs.

**_Associated Abilities:_** DEX, CON.

**_Components._** This tool kit includes a small anvil, tongs,
hammers, heat-resistant hide or cloth towels, calipers,
and billows.

**_Craft Items._** Smithing tools can be used to make items with
the crafting downtime activity.

#### Trapper Tools

Trapper tools are used to set hunting traps, harvest hides or
fur, and craft or repair leather goods like armor, pouches,
or sturdy garments.

**_Associated Abilities:_** DEX, WIS.

**_Components._** This tool kit includes a knife, a small shovel, a
wooden mallet, a small bundle of edgers, hole punchers,
and sturdy needles, thread, leather scraps, a 30-ft. length
of strong cord, a quantity of salt, and tanning oil.

**_Craft Items._** Trapper tools can be used to make items with
the crafting downtime activity.

#### Thieves' Tools

Thieves' tools are used to pick locks, disable traps, and
sabotage unattended items like saddles and doffed armor.

**_Associated Abilities:_** DEX, INT.

**_Components._** This kit includes a roll of lockpicks and
probes, a small, telescoping mirror on a pole, several
triangular files, a long set of scissors, and a pair of pliers.

**_Disarm Traps._** Thieves' tools can be used to disarm traps.

**_Pick Locks._** Thieves' tools can be used to pick locks. If no
DC to pick a lock is provided, a standard nonmagical lock
can be opened with a DC of 15.

#### Tinker Tools

Tinker tools are used to construct mechanical or clockwork
devices, repair damaged devices, or determine how to use
unfamiliar mechanical or clockwork systems.

**_Associated Abilities:_** DEX, INT.

**_Components._** This tool kit includes an array of hand tools,
an array of files, pliers, tweezers, etching styluses, threads,
needles, cloth and leather scraps, glue, loose cogs and
pins, and a few sheets of thinly hammered metal.

**_Craft Items._** Tinker tools can be used to make items with
the crafting downtime activity.

#### Table: Tools

| Tool                  |  Cost | Weight |
| --------------------- | ----: | -----: |
| Alchemist tools       | 50 gp |  8 lb. |
| Artist tools          | 10 gp |  5 lb. |
| Charlatan tools       | 25 gp |  3 lb. |
| Clothier tools        | 10 gp | 10 lb. |
| Construction tools    | 10 gp |  8 lb. |
| _Gaming set_          |       |        |
| - Card set            |  5 sp |      — |
| - Dice set            |  1 sp |      — |
| Smithing tools        | 20 gp |  8 lb. |
| Herbalist tools       |  5 gp |  3 lb. |
| _Musical instruments_ |       |        |
| - Bagpipes            | 30 gp |  6 lb. |
| - Drum                |  6 gp |  3 lb. |
| - Flute               |  2 gp |  1 lb. |
| - Lute                | 35 gp |  2 lb. |
| - Lyre                | 30 gp |  2 lb. |
| - Horn                |  3 gp |  2 lb. |
| Navigator tools       | 25 gp |  2 lb. |
| Provisioner tools     | 20 gp |  9 lb. |
| Trapper tools         |  5 gp |  5 lb. |
| Thieves’ tools        | 25 gp |  1 lb. |
| Tinker tools          | 50 gp | 10 lb. |

## Mounts

### Table: Mounts

| MOUNT          |  COST | SPEED (PER ROUND) | CARRYING CAPACITY |
| -------------- | ----: | ----------------: | ----------------: |
| Donkey or mule |  8 gp |            40 ft. |           420 lb. |
| Horse, draft   | 50 gp |            40 ft. |           540 lb. |
| Horse, riding  | 75 gp |            60 ft. |           480 lb. |
| Horse, war 4   | 00 gp |            60 ft. |           540 lb. |
| Mastiff        | 25 gp |            40 ft. |           195 lb. |
| Pony           | 30 gp |            40 ft. |           225 lb. |

### Mount Gear and Expenses

**_Barding._** Barding is armor designed to protect a mount's
head, neck, chest, and body. Any type of armor shown on
the Armor table can be purchased as barding. The cost
of barding is four times the equivalent armor made for
Humanoids and weighs twice as much.

**_Drawn Objects._** A mount pulling a drawn object like a
carriage, cart, chariot, sled, or wagon can move weight up
to five times its base carrying capacity, including the weight
of the drawn object. If multiple animals pull the same
object, they can add their carrying capacity together.

**_Saddle._** A saddle braces the rider, helping you keep your
seat in battle. It gives you advantage on any ability check or
save you make to remain mounted. At the GM's discretion,
a saddle crafted for an unusually sized or shaped mount
might double or triple the cost.

### Table: Mount Gear and Expenses

| ITEM               |                 COST |                 WEIGHT |
| ------------------ | -------------------: | ---------------------: |
| Barding            | ×4 (base armor cost) | ×2 (base armor weight) |
| _Drawn Objects_    |                      |                        |
| - Carriage         |               100 gp |                600 lb. |
| - Cart             |                15 gp |                200 lb. |
| - Chariot          |               250 gp |                100 lb. |
| - Sled             |                20 gp |                300 lb. |
| - Wagon            |                35 gp |                400 lb. |
| Feed (per day)     |                 5 cp |                 10 lb. |
| Saddle             |                10 gp |                 25 lb. |
| Stabling (per day) |                 5 sp |                      - |

## Services

**_Skilled Hirelings._** Skilled hirelings come with a
proficiency (armor, weapon, tool, vehicle, or skill). A
mercenary, artisan, or scribe would be skilled. The pay
shown is a minimum; true experts might require double or
even triple pay.

**_Untrained Hirelings._** Untrained hirelings are hired for
physical work that doesn't require specialized study.
Examples include laborers, porters, or waiters.

### Table: Common Services

| SERVICE           | COST          |
| ----------------- | ------------- |
| _Coach cab_       |               |
| - Between towns   | 3 cp per mile |
| - Within a city   | 1 cp          |
| _Hireling_        |               |
| - Skilled         | 2 gp per day  |
| - Untrained       | 2 sp per day  |
| Messenger         | 2 cp per mile |
| Road or gate toll | 1 cp          |
| Ship's passage    | 1 sp per mile |

### Spellcasting Services

The Spellcasting Services table provides a rough pricing
guide for spellcasting services, but the GM has final say on
pricing and availability.

#### Table: Spellcasting Services

| Spell Circle | Price                               |
| ------------ | ----------------------------------- |
| Cantrip      | 10 gp + material components cost    |
| 1st          | 50 gp + material components cost    |
| 2nd          | 100 gp + material components cost   |
| 3rd          | 200 gp + material components cost   |
| 4th          | 350 gp + material components cost   |
| 5th          | 650 gp + material components cost   |
| 6th          | 1,500 gp + material components cost |
| 7th          | Priceless                           |
| 8th          | Priceless                           |
| 9th          | Priceless                           |

### Food, Drink, and Lodging

Prices on this table are for individual food items and a
single night's lodging.

#### Table: Food, Drink, and Lodging

| ITEM                 |  COST |
| -------------------- | ----: |
| _Ale_                |       |
| - Pitcher (gallon)   |  2 sp |
| - Mug                |  4 cp |
| _Inn stay (per day)_ |       |
| - Typical room       |  5 sp |
| - Luxury room        |  2 gp |
| _Meals (per day)_    |       |
| - Meal, common       |  3 sp |
| - Meal, feast        |  8 sp |
| _Wine_               |       |
| - Common (pitcher)   |  2 sp |
| - Fine (bottle)      | 10 gp |

# Siege Weapons

Siege weapons are a unique type of object that functions similarly to a standard weapon.

## Elements of a Siege Weapon

Each siege weapon has the following characteristics.

### Size and Type

Every siege weapon has a listed size just like creatures do. Every siege weapon is an object.

### Armor Class and Damage Threshold

Each siege weapon has an AC that determines how difficult it is to hit. In addition, siege weapons have a damage threshold that represents the damage amount that must be met before the siege weapon loses hit points. If the siege weapon is hit by a single instance of damage that fails to meet its damage threshold, it instead takes no damage. A siege weapon's damage threshold appears in parenthesis next to its AC.

### Hit Points

This works like creature hit points, though a siege weapon is destroyed when it drops to 0 HP. A damaged siege weapon can be repaired in the same way a vehicle can. A siege weapon reduced to 0 HP is beyond repair.

### Vulnerabilities, Resistances, and Immunities

Like creatures, siege weapons can be vulnerable, resistant, and immune to certain damage types or conditions. Like most items, siege weapons are immune to poison and psychic damage and to the following conditions: blinded, charmed, deafened, exhaustion, frightened, incapacitated, paralyzed, petrified, poisoned, prone, stunned, and unconscious. Instead of writing all those immunities in each stat block, a siege weapon that fits this standard has Siege Weapon Resilience in the Immune line of its stat block.

### Special Features

Siege weapons don't have actions, but they can be used to create unique effects or to make special attacks. Most siege weapons require at least two actions to use such special features, and armies employing siege weapons tend to have full crews operating them to ensure the siege weapon never ceases firing. The siege weapon's statistics detail if the siege weapon can't be used more than once each round.

**Siege Weapon Damage.** If a siege weapon deals damage, that damage is doubled against objects and structures.

## Siege Weapon Movement

Siege weapons are standalone objects that are most often affixed to a structure, such as a hanging cauldron on a castle wall. While some siege weapons can have wheels, siege weapons don't have a speed and must be carried or moved by creatures or vehicles.

## Attaching Siege Weapons to Vehicles

Siege weapons can be mounted on vehicles large enough to support them. To affix a siege weapon to a vehicle, the vehicle must be at least one size category larger than the siege weapon. The siege weapon costs the same whether it is by itself or affixed to a vehicle. A creature using a siege weapon affixed to a vehicle can use the vehicle's STR modifier instead of the siege weapon's standard attack bonus if the vehicle's bonus is higher, and the attacker can add the vehicle's STR modifier to the damage dealt by the siege weapon.

## Siege Weapon Base Cost

| Item | Cost |
|------|------|
| Ballista | 500 gp |
| Battering Ram | 60 gp (75 gp on wheeled frame) |
| Hanging Cauldron | 50 gp |
| Mangonel | 750 gp |
| Trebuchet | 1,200 gp |

## Siege Weapon Descriptions

This section contains several common siege weapons.

### Ballista
*Large Object*

**Armor Class** 15 (damage threshold 5)  
**Hit Points** 50  
**Immune** Siege Weapon Resilience

Ballistae resemble oversized crossbows, capable of firing massive bolts. These siege weapons are common fixtures on the decks of sailing vessels and other combat-ready vehicles. To fire a ballista, one action must be used to load it, and a second action must be spent to use its Bolt attack.

**Bolt.** *Ranged Weapon Attack:* +6 hit, range 120/480 ft., one target. *Hit:* 16 (3d10) piercing damage.

### Battering Ram
*Large Object*

**Armor Class** 17 (damage threshold 10)  
**Hit Points** 100  
**Immune** Siege Weapon Resilience

Battering rams are oblong constructions of metal and wood used to break through doors, walls, and similar barriers. A battering ram can be fixed in place by suspending it from chains affixed to a ceiling or it can be made portable by affixing it to a wheeled wooden framework. Regardless of how it is supported, at least six Medium creatures or two Large or larger creatures must be within 5 feet of the battering ram and spend at least half their movement speed on their turn to operate the ram. Once the required number of creatures have spent their movement, one of the operators must spend an action to use the Ram attack. A battering ram can perform the Ram action only once per round.

**Ram.** *Melee Weapon Attack:* +8 hit, reach 10 ft., one target. *Hit:* 27 (5d10) bludgeoning damage.

### Hanging Cauldron
*Medium Object*

**Armor Class** 19 (damage threshold 5)  
**Hit Points** 50  
**Immune** Siege Weapon Resilience

Hanging cauldrons are deep iron pots suspended from a fixed metal frame. While the weight of the cauldron is supported by the frame, it is constructed to allow an operator to easily tip the vessel, pouring its contents onto targets that pass below. Before a cauldron can be used, it must be filled with at least 8 gallons of liquid (one fifth of a standard barrel). Pouring 8 gallons of liquid into the cauldron takes one action. The cauldron can hold up to 24 gallons of liquid at once. Once filled, a creature within 5 feet of the cauldron can use an action to cause one of the following effects (determined by the liquid type). Each use of the cauldron expends 8 gallons of liquid, regardless of type.

**Boiling Water.** Scalding-hot water spills out of the cauldron in a 10-foot-radius cylinder centered on a point on the ground directly beneath the cauldron. The cylinder's height is equal to the distance, in feet, between that point and the bottom of the cauldron. Each creature in the area must make a DC 15 DEX save, taking 11 (2d10) fire damage on a failed save, or half as much damage on a successful one.

**Grease.** Slippery cooking grease spills out of the cauldron, splattering in a 5-foot radius area centered on a point on the ground directly beneath the cauldron. The area is difficult terrain for 1 minute. Each creature in the area when the grease is poured must succeed on a DC 13 DEX save or fall prone. For the duration, a creature that enters the area or ends its turn there must also succeed on a DC 13 DEX save or fall prone.

**Flaming Oil.** Flaming oil spills out of the cauldron in a 5-foot-radius cylinder centered on a point on the ground directly beneath the cauldron. The cylinder's height is equal to the distance, in feet, between that point and the bottom of the cauldron. Each creature in the area must make a DC 15 DEX save. On a failure, a creature takes 11 (2d10) fire damage and catches on fire. On a success, a creature takes half the damage and doesn't catch on fire. Flammable objects in the area also catch on fire. A creature or object on fire takes 5 (1d10) fire damage at the start of each of its turns. A creature, including the creature on fire, can take its action to extinguish the fire, ending the effect.

### Mangonel
*Large Object*

**Armor Class** 15 (damage threshold 7)  
**Hit Points** 100  
**Immune** Siege Weapon Resilience

Mangonels are catapults capable of hurling heavy stones (or similar projectiles) incredible distances. Given the high arc of this fire, mangonels are ideal for firing over walls or other forms of cover. To fire a mangonel, one action must be used to load it, and a second action must be spent to use its Launch attack. The mangonel can't target creatures, objects, vehicles, or structures within 60 feet of it.

**Launch.** *Ranged Weapon Attack:* +5 hit, range 200/800 ft., one target. *Hit:* 33 (6d10) bludgeoning damage.

### Trebuchet
*Huge Object*

**Armor Class** 10 (damage threshold 15)  
**Hit Points** 150  
**Immune** Siege Weapon Resilience

Trebuchets are massive and powerful catapults capable of hurling boulders, barrels, and similar projectiles incredible distances. To fire a trebuchet, two actions must be used to load it, one action is required to aim it, and finally, one action must be spent to use its Hurl attack. The trebuchet can't target creatures, objects, vehicles, or structures within 60 feet of it.

**Hurl.** *Ranged Weapon Attack:* +8 hit, range 300/1,200 ft., one target. *Hit:* 55 (10d10) bludgeoning damage. Each creature within 5 feet of the target must succeed on a DC 15 DEX save or take bludgeoning damage equal to half the damage dealt by the attack.

## Vehicles

**_Vehicle Proficiency._** Vehicle proficiency works just like
tool proficiency. When you have proficiency in a vehicle,
choose one type: land or water. You must have multiple
proficiencies to have proficiency with more than one type
of vehicle.

Vehicle proficiency allows you to add your PB to any check
you make to control all vehicles of that type in difficult
circumstances. You can also repair damaged vehicles of
that type.

### Elements Of A Vehicle

Each vehicle has the following characteristics.

#### Size

Every vehicle has a listed size just like creatures do.

#### Type

A vehicle is made to traverse a particular terrain. This is
represented by a vehicle's type, which can include one or
more of the following options.

**Land.** A land vehicle can travel on solid surfaces and across
physical terrain. Such vehicles include war wagons and
sand skimmers. If a land vehicle can traverse horizontal
and upside-down surfaces, it has a climbing speed. If it can
travel underground, it has a burrowing speed.

**Water.** A water vehicle can travel on or below water
or other liquid surfaces. These include ships and
submersibles. If a water vehicle can travel while submerged,
it has a swimming speed.

#### Armor Class & Damage Threshold

Each vehicle has an armor class (AC) which determines
how difficult it is to hit. In addition, vehicles have a damage
threshold which represents the damage amount that must
be met before the vehicle loses hit points. If the vehicle is hit
by a single instance of damage that fails to meet its damage
threshold, it instead takes no damage. A vehicle's damage
threshold appears in parentheses next to the vehicle's AC.

#### Hit Points

This works like creature hit points, though a vehicle is
destroyed when it drops to 0 HP. A vehicle reduced to 0 HP
is beyond repair (see Vehicle Repairs in this section).

#### Speed

A vehicle's movement is measured in feet and miles
per hour. The speed in feet is for use in combat or any
encounter that requires initiative. The miles per hour
and per day measurements are used when traveling long
distances (see Travel Pace).

#### Vulnerabilities, Resistances, and Immunities

Like creatures, vehicles can be vulnerable, resistant, and
immune to certain damage types or conditions. Like most
items, vehicles are immune to poison and psychic damage,
and the following conditions: blinded, charmed, deafened,
exhaustion, frightened, incapacitated, paralyzed, petrified,
poisoned, prone, stunned, and unconscious. Instead
of writing all those immunities out in each stat block, a
vehicle that fits this standard has Vehicle Resilience in the
Immune line of its stat block.

#### Initiative

Each vehicle has a set count for when it acts in initiative
and loses ties with non-vehicles. In case of ties between
vehicles, the GM determines their initiative order. For
more on initiative rules, see the Initiative section.

#### Crew

A vehicle needs a crew to operate. It can't move or take
actions on its turn unless it has the number of required
crew members. A crew member doesn't roll their own
initiative in combat since their actions and movement are
fully dedicated to operating the vehicle.

A crew member must be capable of performing their
tasks. A Beast, for example, is unlikely to have the skills
necessary to operate a vehicle with complex mechanical
controls. While there are no specifically designated roles
for each vehicle or vessel, the GM has final say on whether a
creature qualifies as a crew member.

#### Passengers

Some vehicles can carry passengers in addition to crew.
This section assumes the passengers are Small or Medium
creatures.

#### Cargo Capacity

Cargo capacity refers to the carrying capacity of nonessential goods and materials. This capacity is measured in
pounds or tons; however, a GM can rule that the nature of
a vehicle prevents it from carrying certain kinds of cargo.

#### Actions

On each of its turns, a vehicle with the required number of
crew members a vehicle can move up to its speed and use
one action-just like a PC or monster.

### Vehicle Movement

While in initiative, at the start of a vehicle's turn, crew
members can pick the direction they want the vehicle to
go. Due to size and bulk, most vehicles can only use their
movement to travel in a single direction during their turn. A vehicle with a full crew can move up to its speed on its
turn. A vehicle with fewer than half its crew members can
only move up to half its speed on its turn. A vehicle with no
crew members has a speed of 0 feet.

Some vehicles have the Maneuverable trait which allows
them to turn and travel in different directions on the same
turn. If a vehicle has the Maneuverable trait, it is noted in
parentheses after its speed.

Outside of initiative, crew members can change a vehicle's
direction as they wish.

### Vehicle Repairs

When a vehicle is damaged, a creature with proficiency in
that type of vehicle and the appropriate tools and materials
can attempt to repair the vehicle in one of two ways: a
patch job or replacing parts. Unless specified otherwise,
a creature can't conduct repairs on a vehicle while it is
moving or in use.

#### Patch Job

If the vehicle is damaged but has at least half its hit points
(rounded down), a creature can spend 1 hour patching
the damage. At the end of the hour, the vehicle regains a
number of temporary hit points equal to its AC (up to the
vehicle's hit point maximum). These temporary hit points
last until depleted. A vehicle can only gain temporary hit
points in this way once per day.

#### Replace Parts

If a vehicle has taken damage and has fewer than half its
hit points (rounded down), a creature can spend 1 hour or
more and the necessary gp worth of spare parts to repair
the damage. At the end of each hour, the vehicle regains
hit points equal to its AC (up to the vehicle's hit point
maximum). One hour of repairs requires spare parts worth
a gp amount equal to 10 percent of the vehicle's base cost,
as shown on the Vehicle Base Cost table.

### Vehicle Descriptions

#### Table: Vehicle Base Cost

| VEHICLE              |      Cost | Travel Speed (Per Hour) |
| -------------------- | --------: | ----------------------: |
| _Water Vehicles_     |           |                         |
| - Galley             | 30,000 gp |                   4 mph |
| - Keelboat           |  3,000 gp |                   3 mph |
| - Keelboat (unarmed) |  2,500 gp |                   3 mph |
| - Rowboat            |     50 gp |                   3 mph |

#### Galley

Galleys are massive vessels ideal for transporting cargo
and used by merchants to carry trade goods. These
weighty vessels are equipped with sails, but frequently
rely on dozens of crew members rowing below decks for
propulsion. Since galleys carry stores of cargo, they're
almost always equipped with weaponry and defended by
squadrons of hired swords.

##### Stat Block: Galley

_Gargantuan Water Vehicle (130 ft. by 20 ft.)_

**Armor Class** 15 (damage threshold 20)
**Hit Points** 500
**Speed** 35 ft., 4 mph (96 miles per day)
**Immune** Vehicle Resilience
**Initiative** 4
**Crew** 80
**Passengers** 40
**Cargo Capacity** 150 tons

| STR | DEX | CON | INT | WIS | CHA |
| --: | --: | --: | --: | --: | --: |
|  +3 |  −2 |  +1 |   - |   - |   - |

**_Sails._** While in initiative, the galley's speed is reduced to 15 ft.
when sailing against the wind. While sailing with the wind, its
speed becomes 50 feet.

###### Actions

On its turn, the galley can take two actions, choosing from the
options below (it can take the same action multiple times). It
can take only one action if it has fewer than 40 crew. It can't
move or take actions if it has fewer than 3 crew.

**_Fire Ballista._** Ranged Weapon Attack: +7 hit, range 120/480
ft., one target. Hit: 23 (3d10 + 7) piercing damage.

**_Fire Mangonels._** Ranged Weapon Attack: +7 hit, range
200/800 ft. (can't hit targets within 60 feet), one target. Hit:
34 (5d10 + 7) bludgeoning damage.

**_Row._** The galley takes the Dash action.

#### Keelboat

Keelboats are small sailing vessels that operate with
minimal crew. Keelboats are good for day trips or
transporting small amounts of cargo or passengers.
The keelboat stat block included here is outfitted with a
ballista, but less expensive keelboats without weaponry are
commonly available for purchase.

##### Stat Block: Keelboat

_Gargantuan Water Vehicle (60 ft. by 20 ft.)_

**Armor Class** 15 (damage threshold 10)
**Hit Points** 100
**Speed** 25 ft., 3 mph (72 miles per day)
**Immune** Vehicle Resilience
**Initiative** 7
**Crew** 3
**Passengers** 4
**Cargo Capacity** 1,000 lbs.

| Str | Dex | Con | Int | Wis | Cha |
| --: | --: | --: | --: | --: | --: |
|  +7 |  −3 |  +5 |   - |   - |   - |

**_Sails._** While in initiative, the keelboat's speed is reduced to 15
ft. when sailing against the wind. While sailing with the wind,
its speed becomes 50 feet.

###### Actions

On its turn, the keelboat can take one action, choosing from
the options below. It can't take any actions if it has fewer than
2 crew.

**_Fire Ballista._** Ranged Weapon Attack: +6 hit, range 120/480
ft., one target. Hit: 16 (3d10 + 6) piercing damage.

**_Row._** The keelboat takes the Dash action.

#### Rowboat

Rowboats are powered by rowing and current. They can't
be rowed against any significant current, but they can be
pulled upstream by draft animals on the shore. A rowboat
weighs 100 pounds for portage purposes.

##### Stat Block: Rowboat

_Large Water Vehicle (10 ft. by 5 ft.)_

**Armor Class** 11 (damage threshold 0)
**Hit Points** 50
**Speed** 15 ft. (maneuverable), 3 mph (72 miles per day)
**Immune** Vehicle Resilience
**Initiative** 8
**Crew** 2
**Passengers** 2
**Cargo Capacity** 500 lbs.

| Str | Dex | Con | Int | Wis | Cha |
| --: | --: | --: | --: | --: | --: |
|  +0 |  −1 |  +0 |   - |   - |   - |

**_Lightweight._** If the rowboat is going downstream, add
the speed of the current (typically 3 miles per hour) to its
speed. The rowboat's speed is 0 ft. while traveling against
any significant current.

**_Maneuverable._** The rowboat can move up to its speed and
make one 90-degree turn.

###### Actions

**_Row Hard._** The rowboat takes the Dash action.

# Firearms

Presented here are rules for incorporating gunpowder and firearms into your game.

## Loading a Firearm
Early firearms use a paper "cartridge," a paper cylinder packed with an iron or lead ball, gunpowder, and a primer. To load a firearm, the wielder opens the paper cartridge, pours the gunpowder into the end of the barrel, followed by the ball and the paper. A rod is used to ram the ball and paper down the barrel. Hit or miss, ammunition from a firearm is destroyed once expended.

## Obvious Weapons
When a character makes a ranged attack with a firearm, the firearm releases a thunderous boom audible out to the weapon's maximum range. In addition, firearms release a small puff of smoke when fired.

## Proficiency
A "firearm" is any ranged weapon with the Gunpowder weapon property. Firearms are designated as simple or martial ranged weapons similar to crossbows and other ranged weapons. A PC with simple or martial weapon proficiency also has proficiency with simple or martial firearms, respectively.

## Optional Gunpowder Rules

Here are some optional gunpowder rules:

### Misfire
When you roll a 1 on the d20 for an attack roll with a weapon with the Gunpowder property, the weapon misfires. The attack misses, and you can't use the weapon again until you spend an action to repair it. Repairing a firearm requires a successful DC 10 INT check using tinker tools. If the check fails, the weapon is jammed and can't be used again until the jam is cleared. Clearing a jammed weapon takes 10 minutes of work, using tinker tools.

### Special Training
A character can spend downtime pursuing the Training downtime activity to gain proficiency with martial firearms. Alternatively, training might result in the character becoming proficient with one or more specific firearms.

### Wet Ammunition
A character with a firearm would need to keep paper cartridges in a waterproof container or risk losing the ammunition each time the PC is in the rain or goes for a swim.

## Weapon Options

This section offers an additional weapon option compatible with certain firearms.

### Harmless Fusillade
When you make an attack with this weapon, you can harmlessly discharge the weapon instead of dealing damage while aiming at a creature within the weapon's normal range. On a successful hit, the target must succeed on a CON save or have disadvantage on the next concentration check it makes before the start of your next turn.

## Weapon Properties

The following section includes a new weapon property unique to the firearm weapons described in this book.

### Gunpowder
If you roll the highest possible number on an individual damage die (such as a 6 on a d6 or a 12 on a d12) when you attack with this weapon, you can roll that die again and add the result to the total. For example, if your 2d4 roll resulted in a 3 and 4, you can reroll the 4, adding the result to the current total of 7. When a damage die results in the highest possible number on the die, it is called a "burst."

If you roll the highest possible number again, you can roll the damage die again and add the result to the total, further increasing the weapon's damage. Any of the damage dice for this weapon, including extra dice such as from a critical hit or sneak attack, can burst and result in a reroll. For each attack you make with this weapon, you can reroll only a number of burst dice equal to your proficiency bonus, regardless of how many damage dice result in the highest possible number.

If a single attack with a weapon or item with this property hits multiple targets, the damage is treated as one attack or effect for the purposes of determining how many times the damage can experience a burst, regardless of how many targets take the damage.

### Magazine
Weapons with this property can be loaded with multiple pieces of ammunition, allowing a character to fire the weapon without having to reload between shots—as long as at least one piece of unspent ammunition is in the magazine. Weapons with this property have a number listed next to this property specifying the maximum pieces of ammunition the magazine can hold. For example, a property listed as "Magazine (8)" indicates that weapon's magazine can hold up to eight pieces of ammunition at one time.

## Firearm Weapons

| Weapon | Cost | Damage | Weight | Weapon Option | Properties |
|--------|------|--------|--------|---------------|------------|
| **Simple Ranged Weapons** |
| Pistol | 25 gp | 1d6 piercing | 5 lb. | Harmless Fusillade | Ammunition (range 30/120), Gunpowder, Light, Loading |
| **Martial Ranged Weapons** |
| Arquebus | 100 gp | 2d6 piercing | 20 lb. | Harmless Fusillade | Ammunition (range 25/100), Gunpowder, Heavy, Loading, Two-Handed |
| Blunderbuss | 75 gp | 2d4 piercing | 12 lb. | — | Ammunition (see Special Weapon entry), Gunpowder, Loading, Two-Handed |
| Musket | 50 gp | 1d10 piercing | 10 lb. | Harmless Fusillade | Ammunition (range 80/320), Gunpowder, Loading, Two-Handed |
| Revolving Musket | 200 gp | 1d8 piercing | 12 lb. | Harmless Fusillade | Ammunition (range 80/320), Gunpowder, Magazine (8), Two-Handed |

## Special Weapons

Various firearms are detailed here.

### Arquebus
This very heavy barreled firearm fires solid metal balls and deals devastating damage at short range.

### Blunderbuss
This firearm features a flared muzzle. When you fire the weapon, it releases bullets in a 15-foot cone. Each creature in that area must make a DC 13 DEX save, taking 2d4 piercing damage on a failed save, or half as much damage on a successful one. Each time you use the blunderbuss, it expends 5 pieces of ammunition, and, as with all firearms, the ammunition can't be recovered at the end of battle. Firing a blunderbuss releases a thunderous boom that is audible out to 200 feet.

### Musket
This long-barreled firearm comes in different styles. Its wooden handle often features engravings and other decorative embellishments that have significance to the owner or the original craftsperson.

### Pistol
This small firearm fits easily in one hand, and its wooden handle often features unique engravings, similar to those found on muskets.

### Revolving Musket
This long-barreled firearm holds a removable, metal, cylindrical magazine, which allows the firearm to be fired multiple times before needing to be reloaded. The attached magazine must have at least one paper cartridge loaded into it to make a ranged attack with this weapon.

## Special Gear

Items that support or involve gunpowder or firearms are detailed here.

### Bandolier
This leather, cross-body shoulder belt contains loops and several small pockets. It can hold up to 20 paper cartridges and up to three pistols.

### Cartridge Pouch
This leather belt pouch can hold 30 paper cartridges. The pouch is painted with a retardant material and is resistant to fire damage.

### Gunpowder
Gunpowder is a black, granular, alchemical mixture of sulfur, charcoal, and saltpeter, giving the substance its more common name of "black powder." It is a necessary ingredient in the paper cartridges used by firearms. Igniting an ounce of gunpowder causes it to burn for 1 round, shedding bright light in a 20-foot radius and dim light for an additional 20 feet. Gunpowder in larger quantities can have more devastating effects. When used as a weapon or explosive device, gunpowder has the Gunpowder weapon property:

#### Barrel
A barrel contains enough gunpowder to fill approximately 40 gunpowder horns. Igniting a full barrel of gunpowder causes it to explode at the end of the next round. Each creature within 15 feet of the barrel must make a DC 12 DEX save, taking 5 (2d4) piercing damage and 17 (5d6) fire damage on a failed save, or half as much damage on a successful one.

#### Horn
A horn contains enough gunpowder to create 30 paper cartridges. Igniting a full horn of gunpowder causes it to explode immediately. Each creature within 5 feet of the horn must make a DC 12 DEX save, taking 7 (2d6) fire damage on a failed save, or half as much damage on a successful one.

#### Keg
A keg contains enough gunpowder to fill approximately 20 gunpowder horns. Igniting a full keg of gunpowder causes it to explode at the end of the next round. Each creature within 10 feet of the keg must make a DC 12 DEX save, taking 2 (1d4) piercing damage and 10 (3d6) fire damage on a failed save, or half as much damage on a successful one.

# Magic Items

## Attunement

Some magic items require a creature to form a bond with
them before their magical properties can be used. This
bond is called attunement.

Certain items have a prerequisite for attunement. If the
prerequisite is a class, a creature must be a member of
that class to attune to the item. If the prerequisite is to be
a spellcaster, a creature qualifies if it can cast at least one
spell using a trait or feature, not from an external source
like a magic item. If an item requires attunement, it is
marked in parentheses in the item's description.

Without becoming attuned to an item that requires
attunement, a creature gains only the item's nonmagical
benefits, unless its description states otherwise. For
example, a magic shield that requires attunement
provides the benefits of a normal shield to an unattuned
creature, but none of its magical properties.

Attuning to an item requires a creature to spend one
hour focused on only that item while being in physical
contact with it. This process can occur as part of a short
or long rest. If the process is interrupted, the attunement
attempt fails. Otherwise, at the end of the hour, the
creature gains an intuitive understanding of how to
activate the magical properties of the item, including any
necessary command words.

An item can be attuned to only one creature at a time,
and a creature can be attuned to no more than a number of
items equal to its proficiency bonus (PB) at any one time.
If a creature attempts to attune to an additional item, its
attunement to one item of their choice immediately ends.
In addition, a creature can't attune to more than one of the
same item. For example, a creature can't attune to more
than one ring of protection at a time.

A creature's attunement to an item ends if the creature no
longer satisfies the prerequisites for attunement, if the item
has been more than 100 feet away for at least 24 hours, if
the creature dies, or if another creature attunes to the item.
A creature can also voluntarily end attunement to an item
at any time as an action-unless the item is cursed.

## Equipping Magic Items

Using a magic item's properties requires reading, holding,
ingesting, wearing or wielding the item. A magic item
meant to be worn must be donned in the intended fashion:
boots go on the feet, gloves on the hands, hats and helmets
on the head, and rings on the finger. Magic armor must
be donned, a shield strapped to the arm, a cloak fastened
about the shoulders. A weapon must be held.
In most cases, a magic item meant to be worn can fit a
creature regardless of size or build. Many magic garments
magically adjust themselves to the wearer. Rare exceptions
exist. If the story suggests a good reason for an item to fit
only creatures of a certain size or shape, the GM can rule
that it doesn't adjust.
When a nonhumanoid tries to wear an item, it is up
to GM discretion as to whether the item functions as
intended. A ring placed on a tentacle might work, but a
serpentfolk with a tail instead of legs can't wear boots.

### Multiple Items Of The Same Kind

Use common sense to determine whether more than one
of a given kind of magic item can be worn. A character can't
normally wear more than one pair of footwear, one pair of
gloves or gauntlets, one pair of bracers, one suit of armor,
one item of headwear, and one cloak. Your GM might
allow exceptions. For example, a GM could rule that a PC
can wear a circlet under a helmet or layer two cloaks.

### Paired Items

Items that come in pairs-such as boots, bracers,
gauntlets, and gloves-impart their benefits only if both
items of the pair are worn. For example, a character
wearing a boot of striding and springing on one foot and a boot
of elvenkind on the other foot gains no benefit from either.

## Activating Magic Items

Activating some magic items requires a user to do
something special, such as holding the item and uttering
a command word. The description of an item category or
individual item details how an item is activated. Certain
items use the following rules for their activation.
If an item requires an action to activate, that action isn't a
function of the Use an Object action.

### Command Word

A command word is a word or phrase that must be
spoken for an item to work. A magic item that requires a
command word can't be activated in an area where sound is
prevented, such as in the area of a silence spell.

### Casting Spells From an Item

Some magic items allow you to cast a spell from them.
When you do, the spell is cast at the lowest possible
spell circle, doesn't expend any of your spell slots, and
requires no components, unless the item's description
says otherwise. If a spell cast from a magic item requires
concentration, you must still concentrate on it following
normal concentration rules.

A magic item states whether an action, bonus action,
reaction, or no action is required to cast a spell from it. If
the item doesn't specify a spell's casting time, range, and
duration, or other exceptions to a spell's normal operation,
use the spell's information.

Many items, such as potions, grant a spell's effects with
their usual duration without casting the spell. However,
a few items, potions included, change the casting time,
duration, or other parts of a spell. Any deviations from the
spell's description are identified in the item description.

Some staffs require you to use your own spellcasting
ability to cast a spell from them. If you have more than one
spellcasting ability, you choose which one to use with an
item that requires it. If you don't have a spellcasting ability,
your spellcasting ability modifier is +0 for the item, and
apply your PB.

### Charges

Many magic items have charges that must be expended to
activate their properties. The number of charges an item
has remaining is revealed when an item is identified and
when a creature attunes to it. In addition, when an item
regains charges, the creature attuned to it learns how many
charges it regained. If an item's properties don't specify
a number of charges, it can be used as often as the user
wishes to spend the actions to activate it.

## Magic Item Descriptions

### Ammunition, +1, +2, or +3

_Weapon (Any Ammunition), Rarity Varies; Price Varies_

You have a bonus to attack and damage rolls made with
this piece of magic ammunition. The bonus is determined
by the rarity of the ammunition. Once it successfully hits
a target, the ammunition becomes a nonmagical piece of
ammunition.

#### Table: Magic Ammunition Rarity

| Bonus | Rarity    |          Cost |
| ----: | --------- | ------------: |
|    +1 | Uncommon  |  50 gp (each) |
|    +2 | Rare      | 100 gp (each) |
|    +3 | Very Rare | 350 gp (each) |

### Amulet of Health

_Wondrous Item, Rare (Requires Attunement); 8,000 gp_

Your CON score is 19 while you carry this amulet. It has
no effect on you if your CON is already 19 or higher.

### Amulet of Proof Against Detection and Location

_Wondrous Item, Uncommon (Requires Attunement); 4,000 gp_

While carrying this amulet, you are hidden from divination
magic. You can't be targeted by spells from the divination
school or perceived through magical scrying sensors.

### Animated Shield

_Armor (Shield), Very Rare (Requires Attunement); 30,000 gp_

While wielding this shield, you can speak its command
word as a bonus action to cause it to animate. The shield
leaps into the air and hovers in your space to protect
you as if you were wielding it, leaving your hands free.
The shield remains animated for 1 minute, until you
use a bonus action to end this effect, or until you are
incapacitated or die. Then the shield falls to the ground or
flies into your hand if you have one free.

### Anklets of Alacrity

_Wondrous Item, Common; 50 gp_

This pair of light silver anklets look like a running cat
chasing a swallow in flight. When you roll initiative
while wearing the anklets, you can add your PB to your
initiative. You can't use this property if you are surprised.
Once this feature is used, you can't use it again until you
finish a long rest.

### Apparatus of the Crab

_Wondrous Item, Legendary; 50,000 gp_

This item first appears to be a Large sealed iron barrel
weighing 500 pounds. The barrel has a hidden catch,
which can be found with a successful DC 20 INT
(Investigation) check. Releasing the catch unlocks a hatch
at one end of the barrel, allowing two Medium or smaller
creatures to crawl inside. Ten levers are set in a row at the
far end, each in a neutral position, able to move either
up or down. When certain levers are used, the apparatus
transforms to resemble a giant lobster.
The apparatus of the crab is a Large object with AC 20 and 200 HP, it is immune to poison damage and psychic damage, and it has a walking speed of 30 feet and swimming speed of 30 feet, while its legs and tail are extended.

The apparatus floats on water. It can also go underwater to a depth of 900 feet. Below that, the apparatus takes 2d6 bludgeoning damage per minute from pressure. To be used as a vehicle, the apparatus requires one pilot. While the apparatus's hatch is closed, the compartment is airtight and watertight. The sealed compartment holds enough air for 10 hours of breathing, divided by the number of breathing creatures inside.

A creature in the compartment can use an action to move as many as two of the apparatus's levers up or down. After each use, a lever goes back to its neutral position. See the Levers of the Apparatus table for what each lever does.

#### Table: Levers on the Apparatus

| LEVER | UP                                                                                                                               | DOWN                                                                                                                                        |
| ----: | -------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------- |
|     1 | Legs and tail extend, allowing the apparatus to walk and swim.                                                                   | Legs and tail retract, reducing the apparatus's speed to 0 and making it unable to benefit from bonuses to speed.                           |
|     2 | Forward window shutter opens.                                                                                                    | Forward window shutter closes.                                                                                                              |
|     3 | Side window shutters open (two per side).                                                                                        | Side window shutters close (two per side).                                                                                                  |
|     4 | Two claws extend from the front side of the apparatus.                                                                           | The claws retract.                                                                                                                          |
|     5 | Each extended claw makes the following melee weapon attack: +8 to hit, reach 5 ft., one target. Hit: 7 (2d6) bludgeoning damage. | Each extended claw makes the following melee weapon attack: +8 to hit, reach 5 ft., one target. Hit: The target is grappled (escape DC 15). |
|     6 | The apparatus walks or swims forward.                                                                                            | The apparatus walks or swims backward.                                                                                                      |
|     7 | The apparatus turns 90 degrees left.                                                                                             | The apparatus turns 90 right.                                                                                                               |
|     8 | Eyelike fixtures emit bright light in a 30-foot radius and dim light for an additional 30 feet.                                  | The lights turn off.                                                                                                                        |
|     9 | The apparatus sinks as much as 20 feet in liquid.                                                                                | The apparatus rises up to 20 feet in liquid.                                                                                                |
|    10 | The rear hatch unseals and opens.                                                                                                | The rear hatch closes and seals.                                                                                                            |

### Armor, +1, +2, or +3

_Armor (Light, Medium, Heavy), Rarity Varies; Price Varies_

While wearing this armor, you receive the armor's
standard bonus to AC and an additional AC bonus equal
to its rarity bonus.

#### Table: Armor of Resistance Damage Type

| d10 | DAMAGE TYPE | d10 | DAMAGE TYPE |
| --: | ----------- | --: | ----------- |
|   1 | Acid        |   6 | Necrotic    |
|   2 | Cold        |   7 | Poison      |
|   3 | Fire        |   8 | Psychic     |
|   4 | Force       |   9 | Radiant     |
|   5 | Lightning   |  10 | Thunder     |

### Arrow-Catching Shield

_Armor (Shield), Rare (Requires Attunement); 8,000 gp_

You gain a +2 bonus to AC against ranged attacks while
you wield this shield. This bonus is in addition to the
shield's normal bonus to AC. In addition, when an
attacker makes a ranged attack against a target within 5
feet of you, you can use your reaction to become the target
of the attack instead.

### Arrow of Slaying

_Weapon (Arrow), Very Rare; 650 gp_

An _arrow of slaying_ is a piece of magic ammunition
effective against a particular kind of creature. If a creature
belonging to the type associated with an _arrow of slaying_

takes damage from the arrow, the creature must make a
DC 17 CON save, taking an extra 6d10 piercing damage
on a failed save, or half as much extra damage on a
successful one.

Once an _arrow of slaying_ deals its extra damage to a
creature, it becomes a nonmagical arrow.

Ammunition of this type exists for other weapons, such
as bolts of slaying meant for a crossbow, though arrows are
most common.

### Bag of Beans

_Wondrous Item, Rare; 80,000 gp_

Inside this heavy cloth bag are 3d4 dry beans. The bag
weighs 1/2 pound plus 1/4 pound for each bean it contains.
If you dump the bag's contents out on the ground, they
explode in a 10-foot radius, extending from the beans.
Each creature in the area, including you, must make a DC
15 DEX save, taking 5d4 fire damage on a failed save or
half as much damage on a successful one. The fire ignites
flammable objects in the area that aren't being worn or
carried.

If you remove a bean from the bag, plant it in dirt or sand,
and then water it, the bean produces an effect 1 minute
later from the ground where it was planted. The GM can
choose an effect from the following table, determine it
randomly, or create an effect.

#### Table: Bag Of Beans Effects

| D100  | EFFECT                                                                                                                                                                                                                                                                                                                                                                |
| ----- | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| 01    | 5d4 toadstools sprout. If a creature eats a toadstool, roll any die. On an odd roll, the eater must succeed on a DC 15 CON save or take 5d6 poison damage and become poisoned for 1 hour. On an even roll, the eater gains 5d6 temporary HP for 1 hour.                                                                                                               |
| 02–10 | A geyser erupts and spouts water, beer, berry juice, tea, vinegar, wine, or oil (GM's choice) 30 feet into the air for 1d12 rounds.                                                                                                                                                                                                                                   |
| 11–20 | A treant sprouts. There's a 50 percent chance that the treant is cruelly wicked and attacks.                                                                                                                                                                                                                                                                          |
| 21–30 | An animate, immobile stone statue in your likeness rises. It makes verbal threats against you. If you leave it and others come near, it describes you as the most heinous of villains and directs the newcomers to find and attack you. If you are on the same plane of existence as the statue, it knows where you are. The statue becomes inanimate after 24 hours. |
| 31–40 | A campfire with blue flames springs forth and burns for 24 hours (or until it is extinguished).                                                                                                                                                                                                                                                                       |
| 41–50 | 1d6 + 6 shriekers sprout.                                                                                                                                                                                                                                                                                                                                             |
| 51–60 | 1d4 + 8 bright pink toads crawl forth. When a toad is touched, it transforms into a Large or smaller monster of the GM's choice. The monster remains for 1 minute, then disappears in a puff of bright pink smoke.                                                                                                                                                    |
| 61–70 | A hungry bulette burrows up and attacks.                                                                                                                                                                                                                                                                                                                              |
| 71–80 | A fruit tree grows. It has 1d10 + 20 fruit, 1d8 of which act as randomly determined magic potions, while one acts as an ingested poison of the GM's choice. The tree vanishes after 1 hour. Picked fruit remains, retaining any magic for 30 days.                                                                                                                    |
| 81–90 | A nest of 1d4 + 3 eggs springs up. Any creature that eats an egg must make a DC 20 CON save. On a successful save, a creature permanently increases its lowest ability score by 1, randomly choosing among equally low scores. On a failed save, the creature takes 10d6 force damage from an internal magical explosion.                                             |
| 91–99 | A pyramid with a 60-foot-square base bursts upward. Inside is a sarcophagus containing a mummy lord. The pyramid is treated as the mummy lord's lair, and its sarcophagus contains treasure of the GM's choice.                                                                                                                                                       |
| 00    | A giant beanstalk sprouts, growing to a height of the GM's choice. The top leads where the GM chooses, such as to a great view, a cloud giant's castle, or a different plane of existence.                                                                                                                                                                            |

### Bag of Holding

_Wondrous Item, Uncommon; 1,000 gp_

This bag has an interior space considerably larger than
its outside dimensions, roughly 2 feet in diameter at
the mouth and 4 feet deep. The bag can hold up to 500
pounds, not exceeding a volume of 64 cubic feet. The bag
weighs 15 pounds, regardless of its contents. Retrieving
an item from the bag requires an action.

If the bag is overloaded, pierced, or torn, it ruptures and
is destroyed, and its contents are scattered in another plane
of existence. If the bag is turned inside out, its contents
spill forth, unharmed, but the bag must be put right before
it can be used again. Breathing creatures inside the bag can
survive up to a number of minutes equal to 10 divided by
the number of creatures (minimum 1 minute), after which
time they begin to suffocate.

Placing a _bag of holding_ inside an extradimensional space
created by a _handy haversack_, _portable hole_, or similar item
instantly destroys both items and opens a gate to another
plane. The gate originates where the one item was placed
inside the other. Any creature within 10 feet of the gate
is sucked through it to a random location within another
plane. The gate then closes. The gate is one-way only and
can't be reopened.

### Bag of Tricks

_Wondrous Item, Uncommon; 4,000 gp_

This ordinary bag, made from gray, rust, or tan cloth,
appears empty. Reaching inside the bag, however, reveals
a small, fuzzy object. The bag weighs 1/2 pound.
You can use an action to pull the fuzzy object from the
bag and throw it up to 20 feet. When the object lands, it
transforms into a creature you determine by rolling a d8
and consulting the table that corresponds to the bag's
color. The creature vanishes at the next dawn or when it is
reduced to 0 HP.

The creature is friendly to you and your companions,
and it acts on your turn. You can use a bonus action to
command how the creature moves and what action it
takes on its next turn, or to give it general orders, such as
to attack your enemies. In the absence of such orders, the
creature acts in a fashion appropriate to its nature.
Once three fuzzy objects have been pulled from the bag,
the bag can't be used again until the next dawn.

#### Table: Gray Bag Of Tricks

|  d8 | CREATURE     |
| --: | ------------ |
|   1 | Weasel       |
|   2 | Giant rat    |
|   3 | Badger       |
|   4 | Boar         |
|   5 | Panther      |
|   6 | Giant badger |
|   7 | Dire wolf    |
|   8 | Giant elk    |

#### Table: Rust Bag of Tricks

|  d8 | CREATURE   |
| --: | ---------- |
|   1 | Rat        |
|   2 | Owl        |
|   3 | Mastiff    |
|   4 | Goat       |
|   5 | Giant goat |
|   6 | Giant boar |
|   7 | Lion       |
|   8 | Brown bear |

#### Table: Tan Bag of Tricks

|  d8 | CREATURE     |
| --: | ------------ |
|   1 | Jackal       |
|   2 | Ape          |
|   3 | Baboon       |
|   4 | Axe beak     |
|   5 | Black bear   |
|   6 | Giant weasel |
|   7 | Giant hyena  |
|   8 | Tiger        |

### Bead of Force

_Wondrous Item, Rare; 650 gp each_

This small, black sphere measures 3/4 of an inch in
diameter and weighs 1 ounce. Typically, 1d4 + 4 beads of
force are found together.

You can use an action to throw a bead up to 60 feet. The
bead explodes on impact and is destroyed. Each creature
within a 10-foot radius of where the bead landed must
succeed on a DC 15 DEX save or take 5d4 force damage.
A sphere of transparent force then encloses the area for 1
minute. Any creature that fails the save and is completely
within the area is trapped inside this sphere. Creatures that
succeed on the save, or are partially within the area, are
pushed away from the center of the sphere until they are no
longer inside it. Only breathable air can pass through the
sphere's wall. No attack or other effect can.

An enclosed creature can use its action to push against the
sphere's wall, moving the sphere up to half the creature's
walking speed. The sphere can be picked up, and its magic
causes it to weigh only 1 pound, regardless of the weight of
creatures inside.

### Belt of Dwarvenkind

_Wondrous Item, Rarity Varies (Requires Attunement); 8,000 gp_

- Your CON score increases by 2, to a maximum of 20.
- You have advantage on CHA (Persuasion) checks made to interact with dwarves. In addition, while attuned to the belt, you have a 50 percent chance each day at dawn of growing a full beard if you're capable of growing one, or a visibly thicker beard if you already have one.

If you aren't a dwarf, you gain the following additional benefits while wearing the belt:

- You have advantage on saves against poison, and you have resistance to poison damage.
- You have darkvision to a range of 60 feet.
- You can speak, read, and write Dwarvish.

### Belt of Giant Strength

_Wondrous Item, Rarity Varies (Requires Attunement); Price Varies_

While wearing this belt, your STR score changes to a score
granted by the belt. If your STR is already equal to or
greater than the belt's score, the item has no effect on you.

Six varieties of this belt exist, corresponding with and
having rarity according to six kinds of giants. A belt of stone
giant strength and a belt of frost giant strength look different
but have the same effect.

#### Table: Belt Of Giant Strength Type

| Type              | Strength | Rarity    |      Cost |
| ----------------- | -------: | --------- | --------: |
| Hill giant        |       21 | Rare      | 10,000 gp |
| Stone/frost giant |       23 | Very rare | 30,000 gp |
| Fire giant        |       25 | Very rare | 40,000 gp |
| Cloud giant       |       27 | Legendary | 60,000 gp |
| Storm giant       |       29 | Legendary | 80,000 gp |

### Berserker Axe

_Weapon (Any Axe), Rare (Requires Attunement); 5,000 gp_

You gain a +1 bonus to attack and damage rolls made with
this magic weapon. In addition, while you are attuned to
this weapon, your hit point maximum increases by 1 for
each level you have attained.

**_Curse._** This axe is cursed, and becoming attuned to it
extends the curse to you. As long as you remain cursed, you
are unwilling to part with the axe, keeping it within reach
at all times. You also have disadvantage on attack rolls with
weapons other than this one, unless no foe is within 60 feet
of you that you can see or hear.

When a hostile creature damages you while the axe is in
your possession, you must succeed on a DC 15 WIS save or
go berserk. While berserk, you must use your action each
round to attack the creature nearest to you with the axe.
If you can make extra attacks as part of the Attack action,
you use those extra attacks, moving to attack the next
nearest creature after you fell your current target. If you
have multiple possible targets, you attack one at random.
You are berserk until you start your turn with no creatures
within 60 feet of you that you can see or hear.

### Boots of Elvenkind

_Wondrous Item, Uncommon; 1,000 gp_

While you wear these boots, your steps make no sound,
regardless of the surface you are moving across. You also
have advantage on DEX (Stealth) checks that rely on
moving silently.

### Boots of Galloping

_Wondrous Item, Common; 25 gp_

These white and brown suede boots are patterned like
a horse's coat. While wearing the boots, you can use a
bonus action to make your footfalls sound like those
of a galloping horse. The sound is audible to 300 feet.
A creature who uses their action to make a DC 10 INT
(Investigation) check can determine the sound is unreal.

### Boots of Levitation

_Wondrous Item, Rare (Requires Attunement); 4,000 gp_

While you wear these boots, you can use an action to cast
the _levitate_ spell from them on yourself.

### Boots of Speed

_Wondrous Item, Rare (Requires Attunement); Berserker Axe_

These white and brown suede boots are patterned like
a horse's coat. While wearing the boots, you can use a
bonus action to make your footfalls sound like those
of a galloping horse. The sound is audible to 300 feet.
A creature who uses their action to make a DC 10 INT
(Investigation) check can determine the sound is unreal.

While you wear these boots, you can use a bonus action
and click the boots' heels together. If you do, the boots
double your walking speed, and any creature that makes
an opportunity attack against you has disadvantage on the
attack roll. If you click your heels together again, you end
the effect.

When the boots' property has been used for a total of 10
minutes, the magic ceases to function until the next dawn.

### Boots of Striding and Springing

_Wondrous Item, Uncommon (Requires Attunement); 1,000 gp_

While you wear these boots, your walking speed becomes
30 feet, unless your walking speed is higher, and your
speed isn't reduced if you are encumbered or wearing
heavy armor. In addition, you can jump three times the
normal distance, though you can't jump farther than your
remaining movement would allow.

### Boots of the Winterlands

_Wondrous Item, Uncommon (Requires Attunement); 2,000 gp_

These furred boots are snug and feel quite warm. While
you wear them, you gain the following benefits:

- You have resistance to cold damage.
- You ignore difficult terrain created by ice or snow.
- You can tolerate temperatures as low as −50 degrees
  Fahrenheit without any additional protection. If you
  wear heavy clothes, you can tolerate temperatures as
  low as −100 degrees Fahrenheit.

### Bowl of Commanding Water Elementals

_Wondrous Item, Rare; 14,500 gp_

This bowl is about 1 foot in diameter and half as deep.
It weighs 3 pounds and holds about 3 gallons. While
this bowl is filled with water, you can use an action to
speak the bowl's command word and summon a water
elemental, as if you had cast the conjure elemental spell. The
bowl can't be used this way again until the next dawn.

### Bracers of Archery

_Wondrous Item, Uncommon (Requires Attunement); 2,000 gp_

While wearing these bracers, you have proficiency with
longbow and shortbow, and you gain a +2 bonus to
damage rolls on ranged attacks made with such weapons.

While wearing these bracers, you gain a +2 bonus to AC if
you are wearing no armor and using no shield.

### Bracers of Defense

_Wondrous Item, Rare (Requires Attunement); 8,000 gp_

When you disappear, you leave behind a cloud of smoke,
and you appear in a cloud of smoke at your destination. The
smoke lightly obscures the space you left and the space you
appear in, and it dissipates at the end of your next turn. A
light or stronger wind disperses the smoke.

### Brazier of Commanding Fire Elementals

_Wondrous Item, Rare; 14,500 gp_

This brass brazier weighs 5 pounds. While a fire burns in
it, you can use an action to speak the brazier's command
word and summon a fire elemental, as if you had cast the
conjure elemental spell. The brazier can't be used this way
again until the next dawn.

### Brooch of Shielding

_Wondrous Item, Uncommon (Requires Attunement); 2,000 gp_

While wearing this brooch, you have resistance to force
damage, and you have immunity to damage from the
magic missile spell.

### Broom of Flying

_Wondrous Item, Uncommon; 16,000 gp_

This wooden broom weighs 3 pounds. It functions like
a mundane broom until you stand astride it and speak
its command word. It then hovers beneath you and can
be ridden in the air. It has a flying speed of 50 feet. It can
carry up to 400 pounds, but its flying speed becomes 30
feet while carrying over 200 pounds. The broom stops
hovering when you land.

You can send the broom to travel alone to a destination
within 1 mile of you if you speak the command word, name
the location, and are familiar with that place. The broom
comes back to you when you speak another command
word, provided that the broom is still within 1 mile of you.

### Cape of the Mountebank

_Wondrous Item, Rare; 8,400 gp_

This cape smells faintly of brimstone. While wearing it,
you can use it to cast the dimension door spell as an action.
This property of the cape can't be used again until the
next dawn.

### Carpet of Flying

_Wondrous Item, Very Rare; 200,000 gp_

You can speak the carpet's command word as an action
to make the carpet hover and fly. It moves according to
your spoken directions, provided that you are within 30
feet of it.

Four sizes of _carpet of flying_ exist. The GM chooses the size
of a given carpet or determines it randomly.

#### Table: Flying Carpet Size

| d100   | Size          | Capacity | Flying Speed |
| ------ | ------------- | -------: | -----------: |
| 01–20  | 3 ft. × 5 ft. |  200 lb. |       80 ft. |
| 21–55  | 4 ft. × 6 ft. |  400 lb. |       60 ft. |
| 56–80  | 5 ft. × 7 ft. |  600 lb. |       40 ft. |
| 81–100 | 6 ft. × 9 ft. |  800 lb. |       30 ft. |

A carpet can carry up to twice the weight shown on the
table, but it flies at half speed if it carries more than its
normal capacity.

### Censer of Controlling Air Elementals

_Wondrous Item, Rare; 14,500 gp_

This 6-inch-wide, 1-foot-high vessel resembles a chalice
with a decorated lid. It weighs 1 pound. While incense is
burning in this censer, you can use an action to speak the
censer's command word and summon an air elemental,
as if you had cast the conjure elemental spell. The censer
can't be used this way again until the next dawn.

### Chime of Opening

_Wondrous Item, Rare; 3,000 gp_

This hollow metal tube measures about 1 foot long and
weighs 1 pound. You can strike it as an action, pointing
it at an object within 120 feet of you that can be opened,
such as a door, lid, or lock. The chime issues a clear tone,
and one lock or latch on the object opens unless the sound
can't reach the object. If no locks or latches remain, the
object itself opens.

The chime can be used ten times. After the tenth time, it
cracks and becomes useless.

### Circlet of Blasting

_Wondrous Item, Uncommon; 3,000 gp_

While wearing this circlet, you can use an action to cast
the scorching ray spell with it. When you make the spell's
attacks, you do so with an attack bonus of +5. The circlet
can't be used this way again until the next dawn.

### Cloak of Arachnida

_Wondrous Item, Very Rare (Requires Attunement); 31,000 gp_

This fine garment is made of black silk interwoven with
faint silvery threads. While wearing it, you gain the
following benefits:

- You have resistance to poison damage.
- You have a climbing speed equal to your walking speed.
- You can move up, down, and across vertical surfaces
  and upside down along ceilings, while leaving your
  hands free.
- You can't be caught in webs of any sort and can move
  through webs as if they were difficult terrain.
- You can use an action to cast the web spell (save DC
  13). The web created by the spell fills twice its normal
  area. Once used, this property of the cloak can't be used
  again until the next dawn.

### Cloak of Displacement

_Wondrous Item, Very Rare (Requires Attunement); 60,000 gp_

While you wear this cloak, it projects an illusion that
makes you appear to be standing in a place near your
actual location, causing any creature to have disadvantage
on attack rolls against you. If you take damage, the
illusion ceases to function until the start of your next
turn. This effect is suppressed while you are incapacitated,
restrained, or otherwise unable to move.

### Cloak of Elvenkind

_Wondrous Item, Uncommon (Requires Attunement); 4,000 gp_

While you wear this cloak with its hood up, WIS
(Perception) checks made to see you have disadvantage,
and you have advantage on DEX (Stealth) checks made to
hide, as the cloak's color shifts to camouflage you. Pulling
the hood up or down requires an action.

### Cloak of Protection

_Wondrous Item, Uncommon (Requires Attunement); 2,000 gp_

You gain a +1 bonus to AC and saves while you wear this
cloak.

### Cloak of the Bat

_Wondrous Item, Rare (Requires Attunement); 33,500 gp_

While wearing this cloak, you have advantage on DEX
(Stealth) checks. In an area of dim light or darkness,
you can grip the edges of the cloak with both hands and
use it to fly at a speed of 40 feet. If you ever fail to grip
the cloak's edges while flying in this way, or if you are no
longer in dim light or darkness, you lose this flying speed.
While wearing the cloak in an area of dim light or
darkness, you can use your action to cast polymorph on
yourself, transforming into a bat. While you are in the form
of the bat, you retain your INT, WIS, and CHA scores. The
cloak can't be used this way again until the next dusk.

### Cloak of the Manta Ray

_Wondrous Item, Uncommon; 1,000 gp_

While wearing this cloak with its hood up, you can breathe
underwater, and you have a swimming speed of 60 feet.
Pulling the hood up or down requires an action.

### Crystal Ball

_Wondrous Item, Rarity Varies (Requires Attunement); Price Varies_

The typical crystal ball is a very rare magic item about 6
inches in diameter. While touching it, as an action, you
can cast the scrying spell (save DC 17) from it.

The following crystal ball variants are legendary items and
have additional properties.

**_Crystal Ball of Mind Reading._** While scrying with the
crystal ball, you can use an action to cast the _detect thoughts_
spell (save DC 17) from it, targeting creatures you can see
within 30 feet of the spell's scrying sensor. You don't need
to concentrate to maintain detect thoughts for the duration
of the spell, but it ends if the _scrying_ spell ends.

**_Crystal Ball of Telepathy._** While scrying with the crystal
ball, you can communicate telepathically with creatures
you can see within 30 feet of the spell's scrying sensor (no
action required). You can also use an action to cast the
_suggestion_ spell (save DC 17) from it through the sensor on
one of those creatures. You don't need to concentrate to
maintain suggestion for the duration of the spell, but it ends
if the scrying spell ends. The suggestion spell of the crystal
ball can't be used again until the next dawn.

**_Crystal Ball of True Seeing._** While scrying with the crystal
ball, you have truesight with a radius of 120 feet centered on
the spell's scrying sensor.

#### Table: Crystal Ball Variants

| VARIANT                        | RARITY    |      COST |
| ------------------------------ | --------- | --------: |
| _Crystal Ball_                 | Very Rare | 30,000 gp |
| _Crystal Ball of Mind Reading_ | Legendary | 52,000 gp |
| _Crystal Ball of Telepathy_    | Legendary | 60,000 gp |
| _Crystal Ball of True Seeing_  | Legendary | 70,000 gp |

### Cube of Force

_Wondrous Item, Rare (Requires Attunement); 17,600 gp_

This cube is about 1 inch across. Each face has a distinct
marking that can be pressed. The cube starts with 36 charges.
You can use an action to press one of the cube's faces,
expending a number of charges based on the chosen face,
as shown in the **Cube of Force Faces** table. Each face
has a different effect. If the cube has insufficient charges
remaining, nothing happens.

Otherwise, a barrier of invisible force springs into
existence, forming a cube 15 feet on a side. The barrier is
centered on you, moves with you, and lasts for 1 minute,
until you use an action to press the cube's sixth face, or the
cube runs out of charges.

You can change the barrier's effect by pressing a different
cube face and expending the requisite number of charges,
resetting the duration. When you press a different face, the
current face effect ends.

If your movement causes the barrier to come into contact
with a solid object that can't pass through the cube, you can't
move any closer to that object as long as the barrier remains.

#### Table: Cube Of Force Charge Loss

| SPELL OR ITEM      | CHARGES LOST |
| ------------------ | ------------ |
| _Disintegrate_     | 1d12         |
| _Horn of blasting_ | 1d10         |
| _Passwall_         | 1d6          |
| _Prismatic spray_  | 1d20         |
| _Wall of fire_     | 1d4          |

The cube regains 1d20 expended charges daily at dawn.

#### Table: Cube Of Force Faces

| FACE | CHARGES | EFFECT                                                                                                            |
| ---: | ------: | ----------------------------------------------------------------------------------------------------------------- |
|    1 |       1 | Gases, wind, and fog can't pass through the barrier.                                                              |
|    2 |       2 | Nonliving matter can't pass through the barrier. Walls, floors, and ceilings can pass through at your discretion. |
|    3 |       3 | Living matter can't pass through the barrier.                                                                     |
|    4 |       4 | Spell effects can't pass through the barrier.                                                                     |
|    5 |       5 | Nothing can pass through the barrier. Walls, floors, and ceilings can pass through at your discretion.            |
|    6 |       0 | The barrier deactivates.                                                                                          |

The _cube_ loses charges when the barrier is targeted by
certain spells or comes into contact with certain spell or
magic item effects, as shown on the **Cube of Force Charge Loss** table.

### Dagger of Venom

_Weapon (Dagger), Rare; 8,000 gp_

You gain a +1 bonus to attack and damage rolls made with
this magic weapon.

You can use an action to cause thick, black poison to coat
the blade. The poison remains for 1 minute or until an
attack using this weapon hits a creature. That creature must
succeed on a DC 15 CON save or take 2d10 poison damage
and become poisoned for 1 minute. The dagger can't be
used this way again until the next dawn.

### Dancing Sword

_Weapon (Any Sword), Very Rare (Requires Attunement); 30,000 gp_

You can use a bonus action to toss this magic sword into
the air and speak the command word. When you do so, the
sword begins to hover, flies up to 30 feet, and attacks one
creature of your choice within 5 feet of it. The sword uses
your attack roll and ability score modifier to damage rolls.

While the sword hovers, you can use a bonus action to
cause it to fly up to 30 feet to another spot within 30 feet
of you. As part of the same bonus action, you can cause the
sword to attack one creature within 5 feet of it.

After the hovering sword attacks for the fourth time, it flies
up to 30 feet and tries to return to your hand. If you have
no hand free, it falls to the ground at your feet. If the sword
has no unobstructed path to you, it moves as close to you as
it can and then falls to the ground. It also ceases to hover if
you grasp it or move more than 30 feet away from it.

### Decanter of Endless Water

_Wondrous Item, Uncommon; 4,000 gp_

This stoppered flask sloshes when shaken, as if it contains
water. The decanter weighs 2 pounds. You can use an
action to remove the stopper and speak one of three
command words, whereupon an amount of fresh water or
salt water (your choice) pours out of the flask. The water
stops pouring out at the start of your next turn. Choose
from the following options:

- "Stream" produces 1 gallon of water.
- "Fountain" produces 5 gallons of water.
- "Geyser" produces 30 gallons of water that gushes
  forth in a geyser 30 feet long and 1 foot wide. As a bonus
  action while holding the decanter, you can aim the
  geyser at a creature you can see within 30 feet of you.
  The target must succeed on a DC 13 STR save or take
  1d4 bludgeoning damage and fall prone. Instead of a
  creature, you can target an object that isn't being worn
  or carried and that weighs no more than 200 pounds.
  The object is either knocked over or pushed up to 15 feet
  away from you.

### Defender

_Weapon (Any Sword), Legendar (Requires Attunement); 100,000 gp_

You gain a +3 bonus to attack and damage rolls made with
this magic weapon.
The first time you attack with this sword on each of your
turns, you can transfer some or all of the sword's bonus to
your AC, instead of using the bonus on attacks that turn.
For example, you could reduce the bonus to your attack
and damage rolls to +1 and gain a +2 bonus to AC. The
adjusted bonuses remain in effect until the start of your
next turn, although you must hold the sword to gain a
bonus to AC from it.

### Demon Armor

_Armor (Plate), Very Rare (Requires Attunement); 60,000 gp_

While wearing this armor, you gain a +1 bonus to AC, and
you can understand and speak Abyssal. In addition, the
armor's clawed gauntlets turn unarmed strikes with your
hands into magic weapons that deal slashing damage,
with a +1 bonus to attack rolls and damage rolls and a
damage die of 1d8.
Curse. Once you don this cursed armor, you can't doff it
unless you are targeted by a remove curse spell or similar
magic. While wearing the armor, you have disadvantage
on attack rolls against demons and on saves against their
spells and special abilities.

### Dimensional Shackles

_Wondrous Item, Rare; 8,000 gp_

You can use an action to place these shackles on an
incapacitated creature. The shackles adjust to fit a creature
of Small to Large size. In addition to serving as mundane
manacles, the shackles prevent a creature bound by them
from using any method of extradimensional movement,
including teleportation or travel to a different plane of
existence. They don't prevent the creature from passing
through an interdimensional portal.

You and any creature you designate when you use the
shackles can use an action to remove them. Once every 30
days, the bound creature can make a DC 30 STR (Athletics)
check. On a success, the creature breaks free and destroys
the shackles.

### Dragon Scale Mail

_Armor (Scale Mail), Very Rare (Requires Attunement); 8,000 gp_

Dragon scale mail is made of the scales of one kind of
dragon. Sometimes dragons collect their cast-off scales
and gift them. Other times, hunters skin and preserve the
hide of a dead dragon. In either case, dragon scale mail is
highly valued.

While wearing this armor, you gain a +1 bonus to AC, you
have advantage on saves against the Frightful Presence
and breath weapons of dragons, and you have resistance to
one damage type. The damage type depends on the dragon
scales used to make the armor, as shown on the **Dragon
Scale Mail Type** table.

In addition, you can focus your senses as an action to
magically discern the distance and direction to the closest
dragon within 30 miles of you that is of the same type as the
armor. This special action can't be used again until the next
dawn.

#### Table: Dragon Scale Mail Type

| DRAGON | RESISTANCE |
| ------ | ---------- |
| Black  | Acid       |
| Blue   | Lightning  |
| Brass  | Fire       |
| Bronze | Lightning  |
| Copper | Acid       |
| Gold   | Fire       |
| Green  | Poison     |
| Red    | Fire       |
| Silver | Cold       |
| White  | Cold       |

### Dragon Slayer

_Weapon (Any Sword), Rare; 8,000 gp_

You gain a +1 bonus to attack and damage rolls made with
this magic weapon.

When you hit a dragon with this weapon, the target takes
an extra 3d6 damage of the weapon's type. For the purpose
of this weapon, "dragon" refers to any creature with the
Dragon type, including dragon turtles and wyverns.

### Dust of Disappearance

_Wondrous Item, Uncommon; 100 gp_

Found in a small packet, this powder resembles very fine
sand. There is enough of it for one use. When you use an
action to throw the dust into the air, you and each creature
and object within 10 feet of you become invisible for 2d4
minutes. The duration is the same for all subjects, and the
dust is consumed when its magic takes effect. If a creature
affected by the dust attacks or casts a spell, the invisibility
ends for that creature.

### Dust of Dryness

_Wondrous Item, Uncommon; 250 gp_

This small packet contains 1d6 + 4 pinches of dust. You
can use an action to sprinkle a pinch of it over water.
The dust turns a cube of water 15 feet on a side into one
marble-sized pellet, which floats or rests near where the
dust was sprinkled. The pellet's weight is negligible.

A creature can use an action to smash the pellet against a
hard surface, causing the pellet to shatter and release the
water the dust absorbed. Doing so ends that pellet's magic.
An elemental composed mostly of water that is exposed
to a pinch of the dust must make a DC 13 CON save, taking
10d6 necrotic damage on a failed save, or half as much
damage on a successful one.

### Dust of Sneezing and Choking

_Wondrous Item, Very Rare; Wondrous Item, Uncommon; 100 gp_

Found in a small container, this powder resembles very
fine sand. It appears to be dust of disappearance, and an
identify spell reveals it to be such. There is enough of it for
one use.

When you use an action to throw a handful of the dust
into the air, you and each creature that needs to breathe
within 30 feet of you must succeed on a DC 15 CON save or
become unable to breathe, while sneezing uncontrollably.
A creature affected in this way is incapacitated and
suffocating. As long as it is conscious, a creature can repeat
the save at the end of each of its turns, ending the effect on
it on a success. The restoration spell can also end the effect
on a creature.

### Dwarven Plate

_Armor (Plate), Very Rare; 10,000 gp_

While wearing this armor, you gain a +2 bonus to AC. In
addition, if an effect moves you against your will along the
ground, you can use your reaction to reduce the distance
you are moved by up to 10 feet.

### Dwarven Thrower

_Weapon (Warhammer), Very Rare (Requires Attunement by a Dwarf); 30,000 gp_

You gain a +3 bonus to attack and damage rolls made
with this magic weapon. It has the Thrown property with
a normal range of 20 feet and a long range of 60 feet.
When you hit with a ranged attack using this weapon,
the target takes an extra 1d8 bludgeoning damage or, if
the target is a Giant, it takes an extra 2d8 bludgeoning
damage. The weapon flies back to your hand immediately
after the attack.

### Efficient Quiver

_Wondrous Item, Uncommon; 2,000 gp_

Each of this quiver's three compartments connects
to an extradimensional space that allows the quiver
to hold numerous items while never weighing more
than 2 pounds. The shortest compartment can hold up
to sixty arrows, bolts, or similar objects. The midsize
compartment holds up to eighteen javelins or similar
objects. The longest compartment holds up to six long
objects, such as bows, quarterstaffs, or spears.

You can draw any item the quiver contains as if doing so
from a regular quiver or scabbard.

### Efreeti Bottle

_Wondrous Item, Very Rare; 10,500 gp_

This painted brass bottle weighs 1 pound. When you use
an action to remove the stopper, a cloud of thick smoke
flows out of the bottle. At the end of your turn, the smoke
disappears with a flash of harmless fire, and an efreeti
appears in an unoccupied space within 30 feet of you.

The first time the bottle is opened, the GM rolls to
determine what happens.

#### Table: Efreeti Bottle Effects

| D100  | EFFECT                                                                                                                                                                                                                                                                                                                                                 |
| ----- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ |
| 01–10 | The efreeti attacks you. After fighting for 5 rounds, the efreeti disappears, and the bottle loses its magic.                                                                                                                                                                                                                                          |
| 11–90 | The efreeti serves you for 1 hour, doing as you command. Then the efreeti returns to the bottle, and a new stopper contains it. The stopper can't be removed for 24 hours. The next two times the bottle is opened, the same effect occurs. If the bottle is opened a fourth time, the efreeti escapes and disappears, and the bottle loses its magic. |
| 91–00 | The efreeti can cast the wish spell three times for you. It disappears when it grants the final wish or after 1 hour, and the bottle loses its magic.                                                                                                                                                                                                  |

### Elemental Gem

_Wondrous Item, Uncommon; 650 gp_

This gem contains a mote of elemental energy. When
you use an action to break the gem, an elemental is
summoned as if you had cast the conjure elemental spell,
and the gem's magic is lost. The type of gem determines
the elemental summoned by the spell.

#### Table: Elemental Gem Type

| Gem            | Summoned Elemental |
| -------------- | ------------------ |
| Blue sapphire  | Air elemental      |
| Yellow diamond | Earth Elemental    |
| Red corundum   | Fire elemental     |
| Emerald        | Water Elemental    |

### Eyes of Charming

_Wondrous Item, Uncommon; 1,500 gp_

These crystal lenses fit over the eyes. They have 3 charges
and regain all expended charges daily at dawn. While
wearing them, you can expend 1 charge as an action to
cast the charm spell (save DC 13) on a Humanoid within 30
feet of you, provided that you and the target can see each
other.

### Eyes of Minute Seeing

_Wondrous Item, Uncommon; 1,000 gp_

These crystal lenses fit over the eyes. While wearing them,
you can see much better than normal to a range of 1 foot.
You have advantage on INT (Investigation) checks that
rely on sight while searching an area or studying an object
within that range.

### Eyes of the Eagle

_Wondrous Item, Uncommon (Requires Attunement); 1,000 gp_

These crystal lenses fit over the eyes. While wearing them,
you have advantage on WIS (Perception) checks that rely
on sight. In conditions of clear visibility, you can make out
details of even extremely distant creatures and objects as
small as 2 feet across.

### Feather Token

_Wondrous Item, Rare; 350 gp_

This Tiny object looks like a feather. Different types exist,
each with a different single-use effect. The GM chooses
the kind of feather token or determines it randomly.

**_Anchor._** You can use an action to touch the token to a boat
or ship. For the next 24 hours, the vessel can't be moved by
any means. Touching the token to the vessel again ends the
effect. When the effect ends, the token disappears.

**_Bird._** You can use an action to toss the token 5 feet into the
air. The token disappears and an enormous, multicolored
bird takes its place. The bird has the statistics of a roc, but it
obeys your simple commands and can't attack. It can carry
up to 500 pounds while flying at a speed of 16 miles an
hour or 1,000 pounds at half that speed (to a maximum of
144 miles per day, with a one-hour rest for every 3 hours of
flying). The bird doesn't need to check for exhaustion, but it
disappears after flying its maximum distance for a day or if
it drops to 0 HP. You can dismiss the bird as an action.

**_Fan._** If you are on a boat or ship, you can use an action to
toss the token up to 10 feet in the air. The token disappears,
and a giant flapping fan takes its place. The fan floats and
creates a wind strong enough to fill the sails of one ship,
increasing its speed by 5 miles per hour for 8 hours. You can
dismiss the fan as an action.

**_Swan Boat._** You can use an action to touch the token
to a body of water at least 60 feet in diameter. The token
disappears, and a 50-foot-long, 20-foot-wide boat shaped
like a swan takes its place. The boat is self-propelled and
moves across water at a speed of 6 miles per hour. You can
use an action while on the boat to command it to move or
to turn up to 90 degrees. The boat can carry up to thirty-two
Medium or smaller creatures. A Large creature counts
as four Medium creatures, while a Huge creature counts as
nine. The boat remains for 24 hours and then disappears.
You can dismiss the boat as an action.

**_Tree._** You must be outdoors to use this token. You can use
an action to touch it to an unoccupied space on the ground.
The token disappears, and in its place a nonmagical oak
tree springs into existence. The tree is 60 feet tall and has
a 5-foot-diameter trunk, and its branches at the top spread
out in a 20-foot radius.

**_Whip._** You can use an action to throw this token to a point
within 10 feet of you. The token disappears, and a floating
whip takes its place. You can then use a bonus action to
make a melee spell attack against a creature within 10 feet
of the whip, with an attack bonus of +9. On a hit, the target
takes 1d6 + 5 force damage.

As a bonus action on your turn, you can direct the whip
to fly up to 20 feet and repeat the attack against a creature
within 10 feet of it. The whip disappears after 1 hour,
when you use an action to dismiss it, or when you are
incapacitated or die.

### Figurine of Wondrous Power

_Wondrous Item, Rarity by Figurine; Price Varies_

A figurine of wondrous power is a statuette of a beast small
enough to fit in a pocket. If you use an action to speak
the command word and throw the figurine to a point on
the ground within 60 feet of you, the figurine becomes
a living creature. If the space where the creature would
appear is occupied by other creatures or objects, or if
there isn't enough space for the creature, the figurine
doesn't become a creature.

The creature is friendly to you and your companions.
It understands your languages and obeys your spoken
commands. If you issue no commands, the creature
defends itself but takes no other actions.

The creature exists for a duration specific to each figurine.
At the end of the duration, the creature reverts to its
figurine form. It reverts to a figurine early if it drops to 0
HP or if you use an action to speak the command word
again while touching it. When the creature reverts to a
figurine, its property can't be used again until a certain
amount of time has passed, as specified in the figurine's
description.

**_Bronze Griffon (Rare, 60,000 gp)._** This bronze statuette
is of a griffon rampant. It can become a griffon for up to
6 hours. Once it reverts, it can't be used again until 5 days
have passed.

**_Ebony Fly (Rare, 60,000 gp)._** This ebony statuette is carved
in the likeness of a horsefly. It can become a giant fly for up
to 12 hours and can be ridden as a mount. Once it reverts, it
can't be used again until 2 days have passed.

**_Golden Lions (Rare, 16,000 gp)._** These gold statuettes of
lions are always created in pairs. You can use one figurine
or both simultaneously. Each can become a lion for up to 1
hour. Once a lion has been used, it can't be used again until
7 days have passed.

**_Ivory Goats (Rare, 24,000 gp)._** These ivory statuettes of
goats are always created in sets of three. Each goat looks
unique and functions differently from the others. Their
properties are as follows:

- The goat of traveling can become a Large goat with the
  same statistics as a riding horse. It has 24 charges,
  and each hour or portion thereof it spends in this form
  costs 1 charge. While it has charges, you can use it as
  often as you wish. When it runs out of charges, it reverts
  to a figurine and can't be used again until 7 days have
  passed, when it regains all its charges.
- The goat of travail becomes a giant goat for up to 3
  hours. Once it has been used, it can't be used again until
  30 days have passed.
- The goat of terror becomes a giant goat for up to 3 hours.
  The goat can't attack, but you can remove its horns and
  use them as weapons. One horn becomes a +1 lance,
  and the other becomes a +2 longsword. Removing a
  horn requires an action, and the weapons disappear and
  the horns return when the goat reverts to figurine form.

  In addition, the goat radiates a 30-foot-radius aura
  of terror while you are riding it. Any creature hostile
  to you that starts its turn in the aura must succeed on
  a DC 15 WIS save or be frightened of the goat for 1
  minute, or until the goat reverts to figurine form. The
  frightened creature can repeat the save at the end of
  each of its turns, ending the effect on itself on a success.
  Once it successfully saves against the effect, a creature is
  immune to the goat's aura for the next 24 hours. Once
  the figurine has been used, it can't be used again until 15
  days have passed.

**_Marble Elephant (Rare, 8,000 gp)._** This marble statuette
is about 4 inches high and long. It can become an elephant
for up to 24 hours. Once it has been used, it can't be used
again until 7 days have passed.

**_Obsidian Steed (Very Rare, 50,000 gp)._** This polished
obsidian horse can become a nightmare for up to 24 hours.
The nightmare fights only to defend itself. Once it has been
used, it can't be used again until 5 days have passed.
Each time you use it, the figurine has a 10 percent chance
to ignore your orders, including a command to revert
to figurine form. If you mount the nightmare while it is
ignoring your orders, you and the nightmare are instantly
transported to a random location on the Ethereal Plane,
where the nightmare reverts to figurine form.

**_Onyx Dog (Rare, 8,000 gp)._** This onyx statuette of a
dog can become a mastiff for up to 6 hours. The mastiff has an INT of −1 and can speak Common. It also
has darkvision to a range of 60 feet and can see invisible
creatures and objects within that range. Once it has been
used, it can't be used again until 7 days have passed.

**_Serpentine Owl (Rare, 8,000 gp)._** This serpentine statuette
of an owl can become a giant owl for up to 8 hours. The
owl can telepathically communicate with you at any range
if you and it are on the same plane of existence. Once it has
been used, it can't be used again until 2 days have passed.

**_Silver Raven (Uncommon, 2,000 gp)._** This silver statuette
of a raven can become a raven for up to 12 hours. While
in raven form, the figurine allows you to cast the animal
messenger spell on it as an action. Once it has been used, it
can't be used again until 2 days have passed.

#### Stat Block: Giant Fly

_Large Beast_

- **Armor Class** 11
- **Hit Points** 19 (3d10 + 3)
- **Speed** 30 ft., fly 60 ft.
- **Perception** 10
- **Stealth** 11
- **Senses** darkvision 60 ft.
- **Languages** -

| Str | Dex | Con | Int | Wis | Cha |
| --: | --: | --: | --: | --: | --: |
|  +2 |  +1 |  +1 |  −4 |  +0 |  −4 |

### Flame Tongue

_Weapon (Any Sword), Rare (Requires Attunement); 5,000 gp + base weapon cost_

You can use a bonus action to speak this magic sword's
command word, causing flames to erupt from the blade.
The flames are harmless to you and the weapon. These
flames shed bright light in a 40-foot radius and dim light
for an additional 40 feet. While the sword is ablaze, it deals
an extra 2d6 fire damage to any target it hits. The flames
last until you use a bonus action to speak the command
word again or until you drop or sheathe the sword.

### Flute of Saurian Summoning

_Wondrous Item, Uncommon; Gem of Seeing; 1,000 gp_

This scaly, clawed flute has a musky smell, and it releases
a predatory, screeching roar with reptilian overtones
when blown. You must have proficiency with instruments
(woodwinds) to use this flute. You can use an action to
play the flute and conjure dinosaurs. This works like the
conjure animals spell, except the animals you conjure must
be dinosaurs or Medium or larger lizards. The dinosaurs
remain for 1 hour, until they die, or until you dismiss
them as a bonus action. The flute can't be used to conjure
dinosaurs again until the next dawn.

### Frost Brand

_Weapon (Any Sword), Very Rare (Requires Attunement); 5,000 gp + base weapon cost_

When you hit with an attack using this magic sword, the
target takes an extra 1d6 cold damage. In addition, while
you hold the sword, you have resistance to fire damage.

### Gauntlets of Ogre Power

_Wondrous Item, Uncommon (Requires Attunement); 2,000 gp_

Your STR score is 19 while you wear these gauntlets. They
have no effect on you if your STR is already 19 or higher.

### Gem of Brightness

_Wondrous Item, Uncommon; 200 gp_

This prism has 50 charges. While you are holding it, you
can use an action to speak one of three command words
to cause one of the following effects:

- The first command word causes the gem to shed bright
  light in a 30-foot radius and dim light for an additional
  30 feet. This effect doesn't expend a charge. It lasts until
  you use a bonus action to repeat the command word or
  until you use another function of the gem.
- The second command word expends 1 charge and
  causes the gem to fire a brilliant beam of light at one
  creature you can see within 60 feet of you. The creature
  must succeed on a DC 15 CON save or become blinded
  for 1 minute. The creature can repeat the save at the
  end of each of its turns, ending the effect on itself on a
  success.
- The third command word expends 5 charges and causes
  the gem to flare with blinding light in a 30-foot cone
  originating from it. Each creature in the cone must
  succeed on a DC 15 CON save or become blinded for 1
  minute.

When all of the gem's charges are expended, the gem becomes a nonmagical jewel worth 50 gp.

### Gem of Seeing

_Wondrous Item, Rare (Requires Attunement); 4,400 gp_

This gem has 3 charges. As an action, you can speak the
gem's command word and expend 1 charge. For the next
10 minutes, you have truesight to a range of 120 feet when
you peer through the gem.

The gem regains 1d3 expended charges daily at dawn.

### Giant Slayer

_Weapon (Any Axe or Sword), Rare; 1,500 gp + base item cost_

You gain a +1 bonus to attack and damage rolls made with
this magic weapon.

When you use it to hit a creature with the Giant type, the
creature takes an extra 2d6 damage of the weapon's type
and must succeed on a DC 15 STR save or fall prone.

### Gloves of Missile Snaring

_Wondrous Item, Uncommon (Requires Attunement); 2,000 gp_

These gloves seem to almost meld into your hands when
you don them. When a ranged weapon attack hits you
while you're wearing them, and you have a free hand, you
can use your reaction to reduce the damage by 1d10 + your
DEX modifier. If you reduce the damage to 0, you can
catch the missile if it is small enough for you to hold in
that hand.

### Gloves of Swimming and Climbing

_Wondrous Item, Uncommon (Requires Attunement); 1,000 gp_

While wearing these gloves, climbing and swimming
don't cost you extra movement, and you gain a +5 bonus
to STR (Athletics) checks made to climb or swim.

### Goggles of Night

_Wondrous Item, Uncommon; 1,000 gp_

While wearing these goggles, you have darkvision to a
range of 60 feet. If you already have darkvision, wearing
the goggles increases its range by 60 feet.

### Handy Haversack

_Wondrous Item, Rare; 8,000 gp_

This backpack has a central pouch and two side
pouches, each of which is an extradimensional space.
Each side pouch can hold up to 20 pounds of material,
not exceeding a volume of 2 cubic feet. The large
central pouch can hold up to 8 cubic feet or 80 pounds
of material. The backpack always weighs 5 pounds,
regardless of its contents.

Placing an object in the haversack follows the normal
rules for interacting with objects. Retrieving an item from
the haversack requires you to use an action. When you
reach into the haversack for a specific item, the item is
always magically on top.

The haversack has a few limitations. If it is overloaded, or
if a sharp object pierces it or tears it, the haversack ruptures
and is destroyed. If the haversack is destroyed, its contents
are lost forever, although exceptionally powerful magic
items lost in the bag always turn up again somewhere. If
the haversack is turned inside out, its contents spill forth,
unharmed, and the haversack must be put right before
it can be used again. If a breathing creature is placed
within the haversack, the creature can survive for up to 10
minutes, after which time it begins to suffocate.
Placing the haversack inside an extradimensional space
created by a _bag of holding_, _portable hole_, or similar item
instantly destroys both items and opens a gate to the Astral
Plane. The gate originates where the one item was placed
inside the other. Any creature within 10 feet of the gate is
sucked through it and deposited in a random location on
the Astral Plane. The gate then closes. The gate is one-way
only and can't be reopened.

### Hat of Disguise

_Wondrous Item, Uncommon (Requires Attunement); 1,500 gp_

While wearing this hat, you can use an action to cast
the disguise self spell from it. The spell ends if the hat is
removed.

### Headband of Intellect

_Wondrous Item, Uncommon (Requires Attunement); 1,500 gp_

Your INT score is 19 while you wear this headband. It has
no effect on you if your INT is already 19 or higher.

### Helm of Brilliance

_Wondrous Item, Very Rare (Requires Attunement); 120,000 gp_

This dazzling helm is set with 1d10 diamonds, 2d10
rubies, 3d10 fire opals, and 4d10 opals. Any gem pried
from the helm crumbles to dust. When all the gems are
removed or destroyed, the helm loses its magic.
You gain the following benefits while wearing it:

- You can use an action to cast one of the following
  spells (save DC 18), using one of the helm's gems of the
  specified type as a component: daylight (opal), fireball
  (fire opal), prismatic spray (diamond), or wall of fire
  (ruby). The gem is destroyed when the spell is cast and
  disappears from the helm.
- As long as it has at least one diamond, the helm emits
  dim light in a 30-foot radius when at least one Undead
  is within that area. Any Undead that starts its turn in
  that area takes 1d6 radiant damage.
- As long as the helm has at least one ruby, you have
  resistance to fire damage.
- As long as the helm has at least one fire opal, you can
  use an action and speak a command word to cause
  one weapon you are wielding to burst into flames. The
  flames emit bright light in a 10-foot radius and dim
  light for an additional 10 feet. The flames are harmless
  to you and the weapon. When you hit with an attack
  using the blazing weapon, the target takes an extra 1d6
  fire damage. The flames last until you use a bonus action
  to speak the command word again or until you drop or
  stow the weapon.

  Roll a d20 if you are wearing the helm and take fire
  damage as a result of failing a save against a spell. On a
  roll of 1, the helm emits beams of light from its remaining
  gems. Each creature within 60 feet of the helm other than
  you must succeed on a DC 17 DEX save or be struck by a
  beam, taking radiant damage equal to the number of gems
  in the helm. The helm and its gems are then destroyed.

### Helm of Comprehending Languages

_Wondrous Item, Uncommon; 2,500 gp_

While wearing this helm, you can use an action to cast the
comprehend languages spell from it.

### Helm of Telepathy

_Wondrous Item, Uncommon (Requires Attunement); 3,000 gp_

While wearing this helm, you can use an action to cast the
detect thoughts spell (save DC 13) from it. As long as you
maintain concentration on the spell, you can use a bonus
action to send a telepathic message to a creature you are
focused on. It can reply-using a bonus action to do so-
while your focus on it continues.
While focusing on a creature with detect thoughts, you can
use an action to cast the suggestion spell (save DC 13) from
the helm on that creature. You don't need to concentrate to
maintain suggestion for the duration of the spell, but it ends
if the detect thoughts spell ends. Once used, the suggestion
property can't be used again until the next dawn.

### Helm of Teleportation

_Wondrous Item, Rare (Requires Attunement); 40,000 gp_

This helm has 3 charges. While wearing it, you can use an
action and expend 1 charge to cast the teleport spell from
it. The helm regains 1d3 expended charges daily at dawn.

### Holy Avenger

_Weapon (Any Sword), Legendar (Requires Attunement); 200,000 gp_

You gain a +3 bonus to attack and damage rolls made with
this magic weapon. When you hit a Fiend or an Undead
with it, the target takes an extra 2d10 radiant damage.
While you wield this sword, it creates an aura in a 10-foot
radius around you. You and all creatures friendly to you in
the aura have advantage on saves against spells and other
magical effects. If you have 17 or more levels in the paladin
class, the radius of the aura increases to 30 feet.

### Horn of Blasting

_Wondrous Item, Rare; 8,000 gp_

You can use an action to speak the horn's command word
and then blow the horn, which emits a thunderous blast in
a 30-foot cone that is audible to 600 feet. Each creature in
the cone must make a DC 15 CON save. On a failed save,
a creature takes 5d6 thunder damage and is deafened for
1 minute. On a successful save, a creature takes half as
much damage and isn't deafened. Creatures and objects
made of glass or crystal have disadvantage on the saves
and take 10d6 thunder damage instead of 5d6.

Each use of the horn's magic has a 20 percent chance of
causing the horn to explode. The explosion deals 10d6 fire
damage to the blower and destroys the horn.

### Horseshoes of a Zephyr

_Wondrous Item, Very Rare; 30,000 gp_

These iron horseshoes come in a set of four. While all
four shoes are affixed to the hooves of a horse or similar
creature, they allow the creature to move normally while
floating 4 inches above the ground. This effect means the
creature can cross or stand above nonsolid or unstable
surfaces, such as water or lava. The creature leaves no
tracks and ignores difficult terrain. In addition, the
creature can move at normal speed for up to 12 hours a
day without suffering exhaustion from a forced march.

### Howling Arrows

_Wondrous Item (Any Piercing Ammunition), Common; 10 gp_

These arrowheads are made from hollowed antler and
emit a shrill whistle while airborne. A successful attack
made with a howling arrow deals only half damage, but
the target must succeed on a DC 11 CON save or be
deafened until the end of its next turn.

### Immovable Rod

_Rod, Uncommon; 1,000 gp_

This flat iron rod has a button on one end. You can use
an action to press the button, which causes the rod to
become magically fixed in place. Until you or another
creature uses an action to push the button again, the rod
doesn't move, even if it defies gravity. The rod can hold
up to 8,000 pounds of weight. More weight causes the
rod to deactivate and fall. A creature can use an action to
make a DC 30 STR check, moving the fixed rod up to 10
feet on a success.

### Instant Fortress

_Wondrous Item, Rare; 16,000 gp_

You can use an action to place this 1-inch metal cube
on the ground and speak its command word. The cube
rapidly grows into a fortress that remains until you use
an action to dismiss it, which works only if the fortress is
empty.

The fortress is a square tower, 20 feet on a side and 30
feet high, with arrow slits on all sides and a battlement
atop it. Its interior is divided into two floors, with a ladder
running along one wall to connect them. The ladder ends
at a trapdoor leading to the roof. When activated, the
tower has a small door on the side facing you. The door
opens only at your command, which you can speak as a
bonus action. It is immune to the knock spell and similar
magic, such as that of a chime of opening.

Each creature in the area where the fortress appears
must make a DC 15 DEX save, taking 10d10 bludgeoning
damage on a failed save, or half as much damage on a
successful one. In either case, the creature is pushed to an
unoccupied space outside but next to the fortress. Objects
in the area that aren't being worn or carried take this
damage and are pushed automatically.

The tower is made of adamantine, and its magic prevents
it from being tipped over. The roof, the door, and the walls
each have 100 HP, immunity to damage from nonmagical
weapons excluding siege weapons, and resistance to all
other damage. Only a wish spell can repair the fortress.
Each casting of wish causes the roof, the door, or one wall
to regain 50 HP.

### Ioun Stone

_Wondrous Item, Rarity Varies (Requires Attunement); Price Varies_

Many types of Ioun stones exist, each type a distinct
combination of shape and color.
When you use an action to toss one of these stones into
the air, the stone orbits your head at a distance of 1d3 feet
and confers a benefit to you. Thereafter, another creature
must use an action to grasp or net the stone to separate it
from you, either by making a successful attack roll against
AC 24 or a successful DC 24 DEX (Acrobatics) check.
You can use an action to seize and stow the stone, ending
its effect.

A stone has AC 24, 10 HP, and resistance to all damage.
It is considered an object that is also a carried item while it
orbits your head.

Absorption (Very Rare, 32,000 gp). While this pale
lavender ellipsoid orbits your head, you can use your
reaction to cancel a spell of 4th circle or lower cast by a
creature you can see and targeting only you.
Once the stone has canceled 20 circles worth of spells, it
burns out and turns dull gray, losing its magic. If you are
targeted by a spell whose circle is higher than the number
of spell rings the stone has left, the stone can't cancel it.

**_Agility (Very Rare, 30,000 gp)._** Your DEX score increases
by 2, to a maximum of 20, while this deep red sphere
orbits your head.

**_Awareness (Rare, 4,000 gp)._** You can't be surprised while
this dark blue rhomboid orbits your head.

**_Fortitude (Very Rare, 30,000 gp)._** Your CON score
increases by 2, to a maximum of 20, while this pink
rhomboid orbits your head.

**_Greater Absorption (Legendary, 75,000 gp)._** While this
marbled lavender and green ellipsoid orbits your head, you
can use your reaction to cancel a spell of 8th circle or lower
cast by a creature you can see and targeting only you.
Once the stone has canceled 50 circles worth of spells, it
burns out and turns dull gray, losing its magic. If you are
targeted by a spell whose circle is higher than the number
of spell rings the stone has left, the stone can't cancel it.

**_Insight (Very Rare, 30,000 gp)._** Your WIS score increases
by 2, to a maximum of 20, while this incandescent blue
sphere orbits your head.

**_Intellect (Very Rare, 30,000 gp)._** Your INT score increases
by 2, to a maximum of 20, while this marbled scarlet and
blue sphere orbits your head.

**_Leadership (Very Rare, 30,000 gp)._** Your CHA score
increases by 2, to a maximum of 20, while this marbled
pink and green sphere orbits your head.

**_Mastery (Legendary, 50,000 gp)._** Your proficiency bonus
increases by 1 while this pale green prism orbits your head.

**_Protection (Rare, 8,000 gp)._** You gain a +1 bonus to AC
while this dusty rose prism orbits your head.

**_Regeneration (Legendary, 50,000 gp)._** You regain 15 HP at
the end of each hour this pearly white spindle orbits your
head, provided that you have at least 1 HP.

**_Reserve (Rare, 6,000 gp)._** This vibrant purple prism stores
spells cast into it, holding them until you use them. The
stone can store up to 3 circles worth of spells at a time.
When found, it contains 1d4 − 1 circles of stored spells
chosen by the GM.

Any creature can cast a spell of 1st through 3rd circle into
the stone by touching it as the spell is cast. The spell has
no effect, other than to be stored in the stone. If the stone
can't hold the spell, the spell is expended without effect.
The circle of the slot used to cast the spell determines how
much space it uses.

While this stone orbits your head, you can cast any spell
stored in it. The spell uses the spell slot, spell save DC, spell
attack bonus, and spellcasting ability of the original caster,
but is otherwise treated as if you cast the spell. Once cast,
the spell is expended, freeing up space.

**_Strength (Very Rare, 30,000 gp)._** Your STR score increases
by 2, to a maximum of 20, while this pale blue rhomboid
orbits your head.

**_Sustenance (Rare, 4,000 gp)._** You don't need to eat or
drink while this clear spindle orbits your head.

### Iron Bands of Binding

_Wondrous Item, Rare; 8,000 gp_

This rusty iron sphere measures 3 inches in diameter
and weighs 1 pound. You can use an action to speak
the command word and throw the sphere at a Huge or
smaller creature you can see within 60 feet of you. As the
sphere moves through the air, it opens into a tangle of
metal bands.
Make a ranged attack roll with an attack bonus equal
to your DEX modifier plus your proficiency bonus. On a
hit, the target is restrained until you take a bonus action
to speak the command word to release it. Doing so, or
missing with the attack, causes the bands to contract and
become a sphere once more.
A creature, including the one restrained, can use an action
to make a DC 20 STR check to break the iron bands. On a
success, the item is destroyed, and the restrained creature
is freed. If the check fails, any further attempts made by
that creature automatically fail until 24 hours have elapsed.
Once the bands are used, they can't be used again until the
next dawn.

### Iron Flask

_Wondrous Item, Legendary; 100,000 gp_

This iron bottle has a brass stopper. You can use an action
to speak the flask's command word, targeting a creature
that you can see within 60 feet of you. If the target is native
to a plane of existence other than the one you're on, the
target must succeed on a DC 17 WIS save or be trapped in
the flask. If the target has been trapped by the flask before,
it has advantage on the save. Once trapped, a creature
remains in the flask until released. The flask can hold only
one creature at a time. A creature trapped in the flask
doesn't need to breathe, eat, or drink and doesn't age.
You can use an action to remove the flask's stopper
and release the creature the flask contains. The creature
is friendly to you and your companions for 1 hour and
obeys your commands for that duration. If you give no
commands or give it a command that is likely to result
in its death, it defends itself but otherwise takes no actions.
At the end of the duration, the creature acts in accordance
with its normal disposition.
An identify spell reveals that a creature is inside the flask,
but the only way to determine the type of creature is to
open the flask. A newly discovered bottle might already
contain a creature chosen by the GM or determined
randomly. The GM has the creature's statistics.

### Javelin of Lightning

_Weapon (Javelin), Uncommon; 2,000 gp_

This javelin is a magic weapon. When you hurl it and speak
its command word, it transforms into a bolt of lightning,
forming a line 5 feet wide that extends from you to a
target within 120 feet. Each creature in the line excluding
you and the target must make a DC 13 DEX save, taking
4d6 lightning damage on a failed save, and half as much
damage on a successful one. The lightning bolt turns back
into a javelin when it reaches the target. Make a ranged
weapon attack against the target. On a hit, the target takes
damage from the javelin plus 4d6 lightning damage.
The javelin's property can't be used again until the next
dawn. In the meantime, the javelin can still be used as a
magic weapon.

### Lantern of Revealing

_Wondrous Item, Uncommon; 2,000 gp_

While lit, this hooded lantern burns for 6 hours on 1 pint
of oil, shedding bright light in a 30-foot radius and dim
light for an additional 30 feet. Invisible creatures and
objects are visible if they are in the lantern's bright light.
You can use an action to lower the hood, reducing the
light to dim light in a 5-foot radius.
Luck Blade

### Luck Blade

_Weapon (Any Sword), Legendary (Requires Attunement); Priceless_

You gain a +1 bonus to attack and damage rolls made
with this magic weapon. While carried, you also gain a +1
bonus to saves.

**_Luck._** While you carry this sword, you can call on its luck
(no action required) to reroll one attack roll, ability check,
or save you dislike. You must use the second roll. This
property can't be used again until the next dawn.

**_Wish._** The sword has 1d4 − 1 charges. While holding it, you
can use an action to expend 1 charge and cast the wish spell
from it. This property can't be used again until the next
dawn and never recharges. The sword loses this property if
it has no charges.

### Mace of Smiting

_Weapon (Mace), Rare; 8,000 gp_

You gain a +1 bonus to attack and damage rolls made with
this magic weapon. The bonus increases to +3 when you
use the mace to attack a Construct.

When you roll a 20 on an attack roll with this weapon,
the target takes an extra 2d6 bludgeoning damage, or 4d6
bludgeoning damage if it's a Construct. If a Construct has
25 HP or fewer after taking this damage, it is destroyed.

### Mace of Terror

_Weapon (Mace), Rare (Requires Attunement); 8,800 gp_

This magic weapon has 3 charges. While holding it, you
can use an action and expend 1 charge to release a wave
of terror. Each creature of your choice in a 30-foot radius
extending from you must succeed on a DC 15 WIS save
or become frightened of you for 1 minute. While it is
frightened in this way, a creature must spend its turns
trying to move as far away from you as it can, and it can't
willingly move to a space within 30 feet of you. It also
can't take reactions. For its action, it can use only the
Dash action or try to escape from an effect that prevents it
from moving. If it has nowhere it can move, the creature
can use the Dodge action. At the end of each of its turns, a
creature can repeat the save, ending the effect on itself on
a success.

The mace regains 1d3 expended charges daily at dawn.

### Mantle of Spell Resistance

_Wondrous Item, Rare (Requires Attunement); 8,000 gp_

You have advantage on saves against spells while you wear
this cloak.

### Manual of Golems

_Wondrous Item, Very Rare; Price Varies_

This tome contains information and incantations
necessary to make a particular type of creature with the
Golem tag. The GM chooses the type or determines it
randomly. To decipher and use the manual, you must
be a spellcaster with at least two 5th-circle spell slots. A
creature that can't use a manual of golems and attempts to
read it takes 6d6 psychic damage.

To create a golem, you must spend the time shown on
the **Manual of Golems Type** table, working without
interruption with the manual at hand and resting no more
than 8 hours per day. You must also pay the specified cost to
purchase supplies.

Once you finish creating the golem, the book is consumed
in flames. The golem becomes animate when the ashes of
the manual are sprinkled on it. It is under your control, and
it understands and obeys your spoken commands.

#### Table: Manual Of Golems Type

| d20   | GOLEM |     TIME |       COST |
| ----- | ----- | -------: | ---------: |
| 01–05 | Clay  |  30 days |  65,000 gp |
| 06–17 | Flesh |  60 days |  50,000 gp |
| 18    | Iron  | 120 days | 100,000 gp |
| 19–20 | Stone |  90 days |  80,000 gp |

### Manuals of Advantageous Exertion

_Wondrous Item, Very Rare; 30,000 gp_

These handwritten books contain exercises and insights
into improving your ability scores. Their words are
charged with magic. If you spend 48 hours over a period of
6 days or fewer studying a book's contents and practicing
its guidelines, one of your ability scores increases by 2,
as does your maximum for that score. The ability that
increases is shown on the Manuals of Advantageous
Exertion Type table. Afterward, the manual loses its
magic, but regains it in a century.

#### Table: Manual Of Advantageous Exertion Type

| Manual                           | Ability Score Improved |
| -------------------------------- | ---------------------- |
| Manual of Bodily Health          | CON                    |
| Manual of Gainful Exercise       | STR                    |
| Manual of Quickness of Action    | DEX                    |
| Tome of Clear Thought            | INT                    |
| Tome of Leadership and Influence | CHA                    |
| Tome of Understanding            | WIS                    |

### Marvelous Pigments

_Wondrous Item, Very Rare; 30,000 gp_

Typically found in 1d4 pots inside a fine wooden box with
a brush (weighing 1 pound in total), these pigments allow
you to create three-dimensional objects by painting them
in two dimensions. The paint flows from the brush to
form the desired object as you concentrate on its image.

Each pot of paint is sufficient to cover 1,000 square feet of
a surface, which lets you create inanimate objects or terrain
features-such as a door, a pit, flowers, trees, cells, rooms,
or weapons-that are up to 10,000 cubic feet. It takes 10
minutes to cover 100 square feet.

When you complete the painting, the object or terrain
feature depicted becomes a real, nonmagical object. Thus,
painting a door on a wall creates an actual door that can
be opened to whatever is beyond. Painting a pit on a floor
creates a real pit, and its depth counts against the total area
of objects you create.

Nothing created by the pigments can have a value greater
than 25 gp. If you paint an object of greater value (such as
a diamond or a pile of gold), the object looks authentic,
but close inspection reveals it is made from paste, bone, or
some other worthless material.

If you paint a form of energy such as fire or lightning, the
energy appears but dissipates as soon as you complete the
painting, doing no harm.

### Medallion of Thoughts

_Wondrous Item, Uncommon (Requires Attunement); 31,000 gp_

This medallion has 3 charges. While wearing it, you
can use an action and expend 1 charge to cast the detect
thoughts spell (save DC 13) from it. The medallion regains
1d3 expended charges daily at dawn.

### Necklace of Adaptation

_Wondrous Item, Uncommon (Requires Attunement); 1,000 gp_

While wearing this necklace, you can breathe normally
in any environment. You also have advantage on saves
made against harmful gases and vapors, such as cloudkill
and stinking cloud effects, inhaled poisons, and the breath
weapons of some dragons.

### Necklace of Fireballs

_Wondrous Item, Rare; 200 gp per bead_

This necklace has 1d6 + 3 beads hanging from it. You can
use an action to detach a bead and throw it up to 60 feet
away. When it reaches the end of its trajectory, the bead
detonates as a 3rd-circle fireball spell (save DC 15).

You can hurl multiple beads, or even the whole necklace,
as one action. When you do so, increase the spell circle of
the fireball by 1 for each bead beyond the first.

### Necklace of Prayer Beads

_Wondrous Item, Rare (Requires Attunement by a Cleric, Druid, or Paladin); 75,000 gp_

This necklace has 1d4 + 2 magic beads made from
aquamarine, black pearl, or topaz. It also has nonmagical
beads made from stones such as amber, bloodstone,
citrine, coral, jade, pearl, or quartz. If a magic bead is
removed from the necklace, that bead loses its magic.

Six types of magic beads exist. The GM decides the type
of each bead on the necklace or determines it randomly.
A necklace can have more than one bead of the same type.
To use one, you must be wearing the necklace. Each bead
contains a spell that you can cast from it as a bonus action
(using your spell save DC if necessary). Once a bead's spell
is cast, that bead can't be used again until the next dawn.

#### Table: PRAYER BEAD EFFECTS

| d20   | BEAD OF ...  | SPELL                                       |
| ----- | ------------ | ------------------------------------------- |
| 01–06 | Blessing     | _Bless_                                     |
| 07–12 | Curing       | _Cure wounds_ (2nd-circle) or _restoration_ |
| 13–16 | Favor        | _Greater restoration_                       |
| 17–18 | Smiting      | _Branding smite_                            |
| 19    | Summons      | _Planar ally_                               |
| 20    | Wind walking | _Wind walk_                                 |

### Nine Lives Stealer

_Weapon (Any Sword), Very Rare (Requires Attunement); 8,800 gp_

You gain a +2 bonus to attack and damage rolls made with
this magic weapon.

The sword has 1d8 + 1 charges. If you score a critical hit
against a creature that has fewer than 100 HP, it must
succeed on a DC 15 CON save or be slain instantly as
the sword tears its life force from its body (a Construct
or an Undead is immune). The sword loses 1 charge if
the creature is slain. When the sword has no charges
remaining, it loses this property.

### Oathbow

_Weapon (Longbow), Very Rare (Requires Attunement); 16,000 gp_

When you nock an arrow on this bow, it whispers in
Elvish, “Swift defeat to my enemies.” When you use this
weapon to make a ranged attack, you can, as a command
phrase, say, “Swift death to you who have wronged me.”
The target of your attack becomes your sworn enemy until
it dies or until dawn seven days later. You can have only
one such sworn enemy at a time. When your sworn enemy
dies, you can choose a new one after the next dawn.

When you make a ranged attack roll with this weapon
against your sworn enemy, you have advantage on the roll.
In addition, your target gains no benefit from cover, other
than total cover, and you suffer no disadvantage due to long
range. If the attack hits, your sworn enemy takes an extra
3d6 piercing damage.

While your sworn enemy lives, you have disadvantage on
attack rolls with all other weapons.

### Oil of Etherealness

_Potion, Rare; 2,500 gp_

Beads of this cloudy gray oil form on the outside of its
container and quickly evaporate. The oil can cover a
Medium or smaller creature, along with the equipment
it's wearing and carrying (one additional vial is required
for each size category above Medium). Applying the oil
takes 10 minutes. The affected creature then gains the
effect of the etherealness spell for 1 hour.

### Oil of Sharpness

_Potion, Very Rare; 1,500 gp_

This clear, gelatinous oil sparkles with tiny, ultrathin silver
shards. The oil can coat one slashing or piercing weapon
or up to 5 pieces of slashing or piercing ammunition.
Applying the oil takes 1 minute. For 1 hour, the coated
item is magical and has a +3 bonus to attack and damage
rolls.

### Oil of Slipperiness

_Potion, Uncommon; 8,800 gp_

This sticky black unguent is thick and heavy in the
container, but it flows quickly when poured. The oil
can cover a Medium or smaller creature, along with the
equipment it wears and carries (one additional vial is
required for each size category above Medium). Applying
the oil takes 10 minutes. The affected creature then gains
the effect of a freedom of movement spell for 8 hours.

Alternatively, the oil can be poured on the ground as an
action, where it covers a 10-foot square, duplicating the
effect of the grease spell in that area for 8 hours.

### Pearl of Power

_Wondrous Item, Uncommon (Requires Attunement by a Spellcaster); 500 gp_

While this pearl is on your person, you can use an action
to speak its command word and regain one expended
spell slot. If the expended slot was of 4th circle or higher,
the new slot is 3rd circle. Once you use the pearl, it can't
be used again until the next dawn.

### Periapt of Health

_Wondrous Item, Uncommon; 500 gp_

You are immune to contracting any disease while you
wear this pendant. If you are already infected with a
disease, the effects are suppressed while you wear the
pendant.

### Periapt of Proof against Poison

_Wondrous Item, Rare; 500 gp_

This delicate silver chain has a brilliant-cut black gem
pendant. While you wear it, poisons have no effect on
you. You are immune to the poisoned condition and have
immunity to poison damage.

### Periapt of Wound Closure

_Wondrous Item, Uncommon (Requires Attunement); 500 gp_

While you wear this pendant, you stabilize whenever you
are dying at the start of your turn. In addition, when you
roll a hit die to regain hit points, double the number of hit
points it restores.

### Pipes of Haunting

_Wondrous Item, Uncommon; 2,200 gp_

You must have proficiency with instruments (woodwinds)
to use these pipes. They have 3 charges. You can use an
action to play them and expend 1 charge to create an eerie,
spellbinding tune. Each creature within 30 feet of you
that hears you play must succeed on a DC 15 WIS save
or become frightened of you for 1 minute. If you wish,
all creatures in the area that aren't hostile toward you
automatically succeed on the save. A creature that fails the
save can repeat it at the end of each of its turns, ending the
effect on itself on a success. A creature that succeeds on its
save is immune to the effect of these pipes for 24 hours.
The pipes regain 1d3 expended charges daily at dawn.

### Portable Hole

_Wondrous Item, Rare; 30,000 gp_

This fine black cloth, soft as silk, is folded up to the
dimensions of a handkerchief. It unfolds into a circular
sheet 6 feet in diameter.

You can use an action to unfold a _portable hole_ and place
it on or against a solid surface, whereupon the portable
hole creates an extradimensional hole 10 feet deep. The
cylindrical space within the hole exists on a different
plane, so it can't be used to create open passages. Any
creature inside an open _portable hole_ can exit the hole by
climbing out of it.

You can use an action to close a portable hole by taking hold
of the edges of the cloth and folding it up. Folding the cloth
closes the hole, and any creatures or objects within remain
in the extradimensional space. No matter what's in it, the
hole weighs next to nothing.

If the hole is folded up, a creature within the hole's
extradimensional space can use an action to make a DC 10
STR check. On a successful check, the creature forces its
way out and appears within 5 feet of the portable hole or the
creature carrying it. A breathing creature within a closed
portable hole can survive for up to 10 minutes, after which
time it begins to suffocate.

Placing a portable hole inside an extradimensional space
created by a bag of holding, handy haversack, or similar item
instantly destroys both items and opens a gate to the Astral
Plane. The gate originates where the one item was placed
inside the other. Any creature within 10 feet of the gate is
sucked through it and deposited in a random location on
the Astral Plane. The gate then closes. The gate is one-way
only and can't be reopened.

### Potion of Animal Friendship

_Potion, Uncommon; 50 gp_

When you drink this potion, animals tend to be friendly
to you for 1 hour. For the duration, you can use an action
to cast the animal friendship spell (save DC 13) at any time.
Agitating this muddy liquid brings little bits into view: a
fish scale, a hummingbird tongue, a cat claw, or a squirrel
hair.

### Potion of Clairvoyance

_Potion, Rare; 200 gp_

When you drink this potion, you gain the effect of the
clairvoyance spell. An eyeball bobs in this yellowish liquid
but vanishes when the potion is opened.

### Potion of Climbing

_Potion, Uncommon; 100 gp_

When you drink this potion, you gain a climbing speed
equal to your walking speed for 1 hour. During this time,
you have advantage on STR (Athletics) checks you make to
climb. The potion is separated into brown, silver, and gray
layers resembling bands of stone.

### Potion of Diminution

_Potion, Rare; 200 gp_

When you drink this potion, you gain the "reduce" effect
of the enlarge/reduce spell for 1d4 hours (no concentration
required). The red in the potion's liquid continuously
contracts to a tiny bead and then expands to color the
clear liquid around it.

### Potion of Due Notice

_Potion, Common; 50 gp_
When you drink this potion, double your PB for the
purpose of calculating your passive Insight, Investigation,
and Perception scores for 1 hour. If you don't have
proficiency in any of these skills, you gain proficiency in
them for the duration of the potion. This potion's liquid
has a bright green effervescence.

### Potion of Flying

_Potion, Very Rare; 200 gp_

When you drink this potion, you gain a flying speed equal
to your walking speed for 1 hour and can hover. If you're
in the air when the potion wears off, you fall unless you
have some other means of staying aloft. This potion's clear
liquid floats at the top of its container and cloudy white
impurities drift in it.

### Potion of Gaseous Form

_Potion, Rare; 200 gp_

When you drink this potion, you gain the effect of the
gaseous form spell for 1 hour (no concentration required)
or until you end the effect as a bonus action. This potion's
container seems to hold fog that moves and pours like
water.

### Potion of Giant Strength

_Potion, Rarity Varies; Price Varies_

When you drink this potion, your STR score changes for 1
hour. The type of Giant determines the score, as shown on
the Potion of Giant Strength Type table. The potion has
no effect if your STR score equals or exceeds that score.
This potion's transparent liquid has floating in it a sliver of
fingernail from a giant of the appropriate type. The potion
of frost giant strength and the potion of stone giant strength have
the same effect.

### Potion of Growth

_Potion, Uncommon; 200 gp_

When you drink this potion, you gain the "enlarge" effect
of the enlarge/reduce spell for 1d4 hours (no concentration
required). The red in the potion's liquid continuously
expands from a tiny bead to color the clear liquid around
it and then contracts. Shaking the bottle fails to interrupt
this process.

### Potion of Healing

_Potion, Rarity Varies; Price Varies_

This red, glimmering potion allows you to regain hit
points when you drink it. The number of hit points
depends on the potion’s rarity, as detailed on the
**Potions of Healing Rarity** table.

#### Table: Potions of Healing Rarity

| POTION OF ...      | RARITY    | HP REGAINED |    PRICE |
| ------------------ | --------- | ----------: | -------: |
| _Healing_          | Common    |     2d4 + 2 |    50 gp |
| _Greater Healing_  | Uncommon  |     4d4 + 4 |   100 gp |
| _Superior Healing_ | Rare      |     8d4 + 8 |   350 gp |
| _Supreme Healing_  | Very Rare |   10d4 + 20 | 1,500 gp |

### Potion of Speed

_Potion, Very Rare; 200 gp_

When you drink this potion, you gain the effect of the
haste spell for 1 minute (no concentration required). The
potion's yellow fluid is streaked with black and swirls on
its own.

### Potion of Water Breathing

_Potion, Uncommon; 200 gp_

You can breathe underwater for 1 hour after drinking this
potion. Its cloudy green fluid smells of the sea and has a
jellyfish-like bubble floating in it.

### Restorative Ointment

_Wondrous Item, Uncommon; 100 gp_

This glass jar, 3 inches in diameter, contains 1d4 + 1 doses
of a thick mixture that smells faintly of aloe. The jar and its
contents weigh 1/2 pound.
As an action, one dose of the ointment can be swallowed
or applied to the skin. The creature that receives it regains
2d8 + 2 hit points, ceases to be poisoned, and is cured of
_any disease.; 4,000 gp_

This ring has 3 charges and regains 1d3 expended charges
daily at dawn. While wearing the ring, you can use an action
to expend 1 charge to cast one of the following spells:

### Ring of Animal Influence

_Ring, Rare 4,000 gp_

This ring has 3 charges and regains 1d3 expended charges
daily at dawn. While wearing the ring, you can use an action
to expend 1 charge to cast one of the following spells:

- _Animal friendship_ (save DC 13)
- _Fear_ (save DC 13), targeting only Beasts or creatures with the Animal tag that have an INT score of 3 or lower
- _Speak with animals_

### Ring of Dkinni Summoning

_Ring, Legendary (Requires Attunement) 100,000 gp_

While wearing this ring, you can speak its command
word as an action to summon a particular djinni from
the Elemental Plane of Air. The djinni appears in an
unoccupied space you choose within 120 feet of you. It
remains as long as you concentrate (as if concentrating on
a spell), for up to 1 hour or until it drops to 0 HP. It then
returns to its home plane.

While summoned, the djinni is friendly to you and your
companions. It obeys any commands you give it, no matter
what language you use. If you fail to command it, the djinni
defends itself against attackers but takes no other actions.
After the djinni departs, it can't be summoned again for
24 hours. The ring becomes nonmagical if the djinni dies.

### Ring of Evasion

_Ring, Rare (Requires Attunement); 4,400 gp_

This ring has 3 charges and regains 1d3 expended charges
daily at dawn. When you fail a DEX save while wearing it,
you can use your reaction to expend 1 charge to succeed
on that save instead.

### Ring of Feather Falling

_Ring, Uncommon (Requires Attunement); 4,500 gp_

When you fall while wearing this ring, you descend 60 feet
per round and take no damage from falling.

### Ring of Free Action

_Ring, Rare (Requires Attunement); 7,500 gp_

While you wear this ring, difficult terrain doesn't cost you
extra movement. In addition, magic can neither reduce
your speed nor cause you to be paralyzed or restrained.

### Ring of Invisibility

_Ring, Legendar (Requires Attunement); Ring of Animal Influence_

_Ring, Rar Ring, Legendary (Requires Attunement); 101,000 gp_

While wearing this ring, you can turn invisible as an
action. Anything you are wearing or carrying is invisible
with you. You remain invisible until the ring is removed,
until you attack or cast a spell, or until you use a bonus
action to become visible again.

### Ring of Jumping

_Ring, Uncommon (Requires Attunement); 1,500 gp_

While wearing this ring, you can cast the longstrider spell from it
as a bonus action. You can target only yourself with it.
Ring of Mind Shielding

### Ring of Mind Shielding

_Ring, Uncommon (Requires Attunement); 8,000 gp_

While wearing this ring, you are immune to magic that
allows other creatures to read your thoughts, determine
whether you are lying, or know your creature type.
Creatures can telepathically communicate with you only
if you allow it.

You can use an action to cause the ring to become invisible
until you use another action to make it visible, until you
remove the ring, or until you die.

If you die while wearing the ring, your soul enters it,
unless it already houses a soul. You can remain in the
ring or depart for the afterlife. As long as your soul is in
the ring, you can telepathically communicate with any
creature wearing it. A wearer can't prevent this telepathic
communication.

### Ring of Protection

_Ring, Rare (Requires Attunement); 8,000 gp_

You gain a +1 bonus to AC and saves while wearing this
ring.
Ring of Regeneration

### Ring of Regeneration

_Ring, Very Rare (Requires Attunement); 55,000 gp_

While wearing this ring, you regain 1d6 HP every 10
minutes, provided that you have at least 1 HP. If you lose a
body part, the ring causes the missing part to regrow and
return to full functionality after 1d6 + 1 days if you have at
least 1 HP the whole time.

### Ring of Resistance

_Ring, Rare (Requires Attunement); 8,000 gp_

You have resistance to one damage type while wearing this
ring. The gem in the ring indicates the type, which the GM
chooses or determines randomly.

#### Table: Ring Of Resistance Damage Type

| d10 | TYPE      | GEM        |
| --: | --------- | ---------- |
|   1 | Acid      | Pearl      |
|   2 | Cold      | Tourmaline |
|   3 | Fire      | Garnet     |
|   4 | Force     | Sapphire   |
|   5 | Lightning | Citrine    |
|   6 | Necrotic  | Jet        |
|   7 | Poison    | Amethyst   |
|   8 | Psychic   | Jade       |
|   9 | Radiant   | Topaz      |
|  10 | Thunder   | Spinel     |

### Ring of Spell Storing

_Ring, Rare (Requires Attunement); 10,500 gp_

This ring stores spells cast into it, holding them until
the attuned wearer uses them. The ring can store up to 5
circles' worth of spells at a time. When found, it contains
1d6 − 1 circles of stored spells chosen by the GM.
Any creature can store a spell it knows or has prepared of 1st through 5th circle in the ring by taking an action and touching the ring, expending a spell slot as if the creature had cast the spell. If the ring
can't hold the spell, the spell is expended without effect.
The circle of the spell slot used to cast the spell determines
how much space it uses.

While wearing this ring, you can cast any spell stored in it, using the appropriate action. If the spell requires a trigger, the conditions for that trigger must be met to cast the spell. The spell uses the slot circle, spell save DC, spell attack
bonus, and spellcasting ability of the original caster, but is
otherwise treated as if you cast the spell. A spell cast from
the ring is no longer stored in it, freeing up space.

### Ring of Spell Turning

_Ring, Legendar (Requires Attunement); 100,000 gp_

While wearing this ring, you have advantage on saves
against any spell that targets only you. In addition, if you
roll a 20 for the save and the spell is 7th circle or lower, the
spell has no effect on you and instead targets the caster,
using the spell slot, spell save DC, attack bonus, and
spellcasting ability of the caster.

### Ring of Swimming

_Ring, Uncommon; 1,000 gp_

While wearing this ring, your swimming speed is 40 feet.

### Ring of Telekinesis

_Ring, Very Rare (Requires Attunement); 36,500 gp_

While wearing this ring, you can cast the telekinesis spell,
but you can target only objects that aren't being worn or
carried.

### Ring of the Ram

_Ring, Rare (Requires Attunement); 4,400 gp_

This ring has 3 charges and regains 1d3 expended charges
daily at dawn. While wearing the ring, you can use an
action to expend 1 to 3 of its charges to make a ranged
spell attack against one creature or object that isn't being
carried within 60 feet of you. The ring produces a spectral
ram's head and makes its attack roll with a +7 bonus. On a
hit, for each charge you spend, the target takes 2d10 force
damage and is pushed 5 feet away from you.

### Ring of Three Wishes

_Ring, Legendary; 130,000 gp_

This ring has 3 charges. While wearing it, you can use an
action to expend 1 charge to cast the wish spell from it. The
ring becomes nonmagical when you use the last charge.

### Ring of Water Walking

_Ring, Uncommon; 3,000 gp_

While wearing this ring, you can stand on and move
across any liquid surface as if it were solid ground.

#### Ring of X-Ray Vision

_Ring, Uncommon; 2,000 gp_

While wearing this ring, you can use an action to speak
its command word. When you do so, you can see into and
through solid matter for 1 minute. This vision has a radius
of 30 feet. To you, solid objects within that radius appear
transparent and don't prevent light from passing through
them. The vision can penetrate 1 foot of stone, 1 inch of
common metal, or up to 3 feet of wood or dirt. Thicker
substances block the vision, as does a thin sheet of lead.
When you use the ring again before taking a long rest, you
must succeed on a DC 15 CON save or gain one level of
exhaustion.

### Ring Shooting Stars

_Ring, Very Rare (Requires Attunement Outdoors at Night); 33,000 gp_

While wearing this ring in dim light or darkness, as an
action you can cast dancing lights and light from it.
For its other properties, the ring has 6 charges.

The ring regains 1d6 expended charges daily at dawn.

**_Faerie Fire._** You can expend 1 charge as an action to cast
faerie fire from the ring.

**_Shooting Stars._** You can expend 1 to 3 charges as an action.
For every charge you expend, you launch a glowing mote of
light from the ring at a point you can see within 60 feet of
you. Each creature within a 15-foot cube originating from
that point is showered in sparks and must make a DC 15
DEX save, taking 5d4 fire damage on a failed save or half as
much damage on a successful one.

**_Ball Lightning._** You can expend 2 charges as an action to
create one to four 3-foot-diameter spheres of lightning. The
more spheres you create, the less power each sphere has.

Each sphere appears in an unoccupied space you can
see within 120 feet of you. The spheres last as long as you
concentrate (as if concentrating on a spell), up to 1 minute.
Each sphere sheds dim light in a 30-foot radius. As a
bonus action, you can move each sphere up to 30 feet, but
no farther than 120 feet away from you. When a creature
other than you comes within 5 feet of a sphere, the sphere
discharges lightning at that creature and disappears. That
creature must make a DC 15 DEX save. On a failed save,
the creature takes lightning damage based on the number
of spheres you created.

#### Table: Ball Lightning Damage

| SPHERES | LIGHTNING DAMAGE |
| ------- | ---------------- |
| 4       | 2d4              |
| 2       | 5d4              |
| 3       | 2d6              |
| 1       | 4d12             |

### Ring Warmth

_Ring, Uncommon (Requires Attunement); 2,000 gp_

While wearing this ring, you are resistant to cold damage. In addition, you and your equipment are
unharmed by temperatures as low as -50 degrees
Fahrenheit.

### Robe of Eyes

_Wondrous Item, Rare (Requires Attunement); 8,000 gp_

This robe is adorned with eyelike patterns. While you wear
the robe, you gain the following benefits:

- You can see in all directions, and you have advantage on
  WIS (Perception) checks that rely on sight.
- You have darkvision to a range of 120 feet.
- You can see invisible creatures and objects, as well as see
  into the Ethereal Plane, to a range of 120 feet.
  The eyes on the robe can't be closed or averted. Although
  you can close or avert your own eyes, you are never
  considered to be doing so while wearing this robe.
  A light spell cast on the robe or a daylight spell cast within
  5 feet of the robe causes you to be blinded for 1 minute. At
  the end of each of your turns, you can make a CON save
  (DC 11 for light or DC 15 for daylight), ending the blindness
  on a success.

### Robe of Scintillating Colors

_Wondrous Item, Very Rare (Requires Attunement); 33,000 gp_

This robe has 3 charges and regains 1d3 expended charges
daily at dawn. While you wear it, you can use an action and
expend 1 charge to cause the garment to display a shifting
pattern of dazzling hues until the end of your next turn.
During this time, the robe sheds bright light in a 30-foot
radius and dim light for an additional 30 feet. Creatures
that can see you have disadvantage on attack rolls against
you. In addition, any creature in the bright light that can
see you when the robe's power is activated must succeed
on a DC 15 WIS save or become stunned until the effect
ends.

### Robe of Stars

_Wondrous Item, Very Rare (Requires Attunement); 50,500 gp_

This black or dark blue robe is embroidered with small
white or silver stars. You gain a +1 bonus to saves while
you wear it.

Six stars, located on the robe's upper front portion, are
particularly large. While wearing this robe, you can use an
action to pull off one of the stars and use it to cast magic
missile as a 5th-ringe spell. Daily at dusk, 1d6 removed stars
reappear on the robe.

While you wear the robe, you can use an action to enter
the Astral Plane along with everything you are wearing
and carrying. You remain there until you use an action to
return to the plane you were on. You reappear in the last
space you occupied, or if that space is occupied, the nearest
unoccupied space.

### Robe of the Archmagi

_Wondrous Item, Legendary (Requires Attunement by a Sorcerer, Warlock, or Wizard); 100,000 gp_

This elegant garment is made from exquisite cloth of
white, gray, or black and adorned with silvery runes.
You gain these benefits while wearing the robe:

- If you aren’t wearing armor, your base AC is 15 + your DEX modifier.
- You have advantage on saves against spells and other magical effects.
- Your spell save DC and spell attack bonus each increase by 2.

### Robe of Useful Items

_Wondrous Item, Uncommon; 5,000 gp_

This robe has cloth patches of various shapes and colors
covering it. While wearing the robe, you can use an action
to detach one of the patches, causing it to become the
object or creature it represents. Once the last patch is
removed, the robe becomes an ordinary garment.

The robe has two of each of the following patches:

- Dagger - Bullseye lantern (filled and lit) - Steel mirror - 10-foot pole - Hempen rope (50 feet, coiled) - Sack
  In addition, the robe has 4d4 other patches. The GM
  chooses the patches or determines them randomly.

#### Table: Patch Effects

| d100  | PATCH                                                                                                                                                                                             |
| ----- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| 01–08 | Bag of 100 gp                                                                                                                                                                                     |
| 09–15 | Silver coffer (1 foot long, 6 inches wide and deep) worth 500 gp                                                                                                                                  |
| 16–22 | Iron door (up to 10 feet wide and 10 feet high, barred on one side of your choice), which you can place in an opening you can reach; it conforms to fit the opening, attaching and hinging itself |
| 23–30 | Ten gems worth 100 gp each                                                                                                                                                                        |
| 31–44 | Wooden ladder (24 feet long)                                                                                                                                                                      |
| 45–51 | A riding horse with saddle bags                                                                                                                                                                   |
| 52–59 | Pit (a cube 10 feet on a side), which you can place on the ground within 10 feet of you                                                                                                           |
| 60–68 | Four potions of healing                                                                                                                                                                           |
| 69–75 | Rowboat (12 feet long)                                                                                                                                                                            |
| 76–83 | Spell scroll containing one spell of 1st to 3rd circle                                                                                                                                            |
| 84–90 | Two mastiffs                                                                                                                                                                                      |
| 91–96 | Window (2 feet by 4 feet, up to 2 feet deep), which you can place on a vertical surface you can reach                                                                                             |
| 97–00 | Portable ram                                                                                                                                                                                      |

### Rod of Absorption

_Rod, Very Rare (Requires Attunement); 30,000 gp_

While holding this rod, you can use your reaction to
absorb a spell that targets only you. The absorbed spell's
effect is canceled, and the spell's energy-not the spell
itself-is stored in the rod. The energy has the same circle
as the spell when it was cast. The rod can absorb and store
up to 50 circles' worth of energy over the course of its
existence. Once the rod absorbs 50 circles' worth of spell
slots, it can't absorb more. If you are targeted by a spell
that the rod can't store, the rod has no effect on that spell.
When you become attuned to the rod, you know how
many circles' worth of spell energy the rod has absorbed
over the course of its existence, and how many circles it
currently has stored.

If you are a spellcaster holding the rod, you can convert
energy stored in it into spell slots to cast spells you have
prepared or know. You can create spell slots only of a
circle equal to or lower than your own spell slots, up to a
maximum of 5th circle. You use the stored rings in place
of your slots, but otherwise cast the spell as normal. For
example, you can use 3 circles stored in the rod as a 3rdcircle spell slot.
A newly found rod of absorption has 1d10 circles of spell
energy stored in it already. A rod that can no longer
absorb spell energy and has no energy remaining becomes
nonmagical.

### Rod of Alertness

_Rod, Very Rare (Requires Attunement); 121,000 gp_

This rod has a flanged head and the following properties.

**_Alertness._** While holding the rod, you have advantage on
WIS (Perception) checks and on rolls for initiative.

**_Spells._** While holding the rod, you can use an action to cast
one of the following spells from it: detect evil and good, detect
magic, detect poison and disease, or see invisibility.

**_Protective Aura._** As an action, you can plant the haft
end of the rod in the ground, whereupon the rod's head
sheds bright light in a 60-foot radius and dim light for an
additional 60 feet. While in that bright light, you and any
creature that is friendly to you gain a +1 bonus to AC and
saves and can sense the location of any invisible hostile
creature that is also in the bright light.

The rod's head stops glowing and the effect ends after 10
minutes, or when a creature uses an action to pull the rod
from the ground. This property can't be used again until
the next dawn.

### Rod of Rulership

_Rod, Rare (Requires Attunement); 11,500 gp_

You can use an action to present the rod and command
obedience from each creature of your choice that you
can see within 120 feet of you. Each target must succeed
on a DC 15 WIS save or be charmed by you for 8 hours.
While charmed in this way, the creature regards you as
its trusted leader. If harmed by you or your companions,
or commanded to do something contrary to its nature, a
target ceases to be charmed in this way.
The rod can't be used again until the next dawn.

### Rod of Security

_Rod, Very Rare; 100,000 gp_

While holding this rod, you can use an action to activate it.
The rod then instantly transports you and up to 199 other
willing creatures you can see to a paradise that exists
in an extraplanar space. You choose the form that the
paradise takes. It could be a tranquil garden, lovely glade,
cheery tavern, immense palace, tropical island, fantastic
carnival, or whatever else you can imagine. Regardless of
its nature, the paradise contains enough water and food to
sustain its visitors. Everything else that can be interacted
with inside the extraplanar space can exist only there. For
example, a flower picked from a garden in the paradise
disappears if it is taken outside the extraplanar space.

For each hour spent in the paradise, a visitor regains hit
points as if it had spent 1 hit die. Although time passes
normally in the paradise, creatures don't age there. Visitors
can remain in the paradise for up to 200 days divided by the
number of creatures present (round down).

When the time runs out or you use an action to end it, all
visitors reappear in the location they occupied when you
activated the rod, or an unoccupied space nearest that spot.
The rod can't be used again until 10 days have passed.

### Rope of Climbing

_Wondrous Item, Uncommon; 1,000 gp_

This 60-foot length of silk rope weighs 3 pounds and can
hold up to 3,000 pounds. If you hold one end of the rope
and use an action to speak the command word, the rope
animates. As a bonus action, you can command the other
end to move toward a destination you choose. That end
has a flying speed of 10 feet. It moves 10 feet on your turn
when you first command it and 10 feet on each of your
turns until reaching its destination, up to its maximum
length away, or until you tell it to stop. You can also tell the
rope to fasten itself securely to an object or to unfasten
itself, to knot or unknot itself, or to coil itself for carrying.

If you tell the rope to knot, large knots appear at 1-foot
intervals along the rope. While knotted, the rope shortens
to a 50‑foot length and grants advantage on checks made to
climb it.

The rope has AC 20 and 20 HP. It regains 1 HP every 5
minutes as long as it has at least 1 HP. If the rope drops to 0
HP, it is destroyed.

### Rope of Entanglement

_Wondrous Item, Rare; 8,000 gp_

This rope is 30 feet long and weighs 3 pounds. If you
hold one end of the rope and use an action to speak its
command word, the other end darts forward to entangle a
creature you can see within 20 feet of you. The target must
succeed on a DC 15 DEX save or become restrained.

You can release the creature by using a bonus action to
speak a second command word. A target restrained by the
rope can use an action to make a DC 15 STR or DEX check
(target's choice). On a success, the creature is no longer
restrained by the rope.

The rope has AC 20 and 20 HP. It regains 1 HP every 5
minutes as long as it has at least 1 HP. If the rope drops to 0
HP, it is destroyed.

### Scimitar of Speed

_Weapon (Scimitar), Very Rare (Requires Attunement); 60,000 gp_

You gain a +2 bonus to attack and damage rolls made with
this magic weapon. In addition, you can make one attack
with it as a bonus action on each of your turns.

### Shield, +1, +2, or +3

_Armor (Shield), Rarity Varies; Price Varies_

While wielding this shield, you have a bonus to AC
determined by the shield's rarity. This bonus is in addition
to the shield's normal bonus to AC.

#### Table: Magic Shield Rarity

| BONUS | RARITY    |                        PRICE |
| ----- | --------- | ---------------------------: |
| +1    | Uncommon  |  1,000 gp + shield base cost |
| +2    | Rare      |  5,000 gp + shield base cost |
| +3    | Very Rare | 15,000 gp + shield base cost |

### Shield of Clamor

_Armor (Shield), Common; 25 gp + base shield cost_

The surface of this shield vibrates unpredictably when
struck. When a weapon attack misses you while you are
wielding this shield, it makes one of several sounds that
are audible to 60 feet. Choose which sound it makes from
the following options: a beaten drum, a duck’s quack,
a gopher’s screech, an elephant’s trumpet, a foghorn, a
bleating goat, or a ringing bell.

### Shield of Missile Attraction

_Armor (Shield), Rare (Requires Attunement); 8,000 gp_

While holding this shield, you have resistance to damage
from ranged weapon attacks.

**_Curse._** This shield is cursed. Attuning to it curses you until
you are targeted by the remove curse spell or similar magic.
Removing the shield fails to end the curse on you. When
a ranged weapon attack is made against a target within
10 feet of you, the curse causes you to become the target
instead.

### Slippers of Spider Climbing

_Wondrous Item, Uncommon (Requires Attunement); 2,000 gp_

While you wear these light shoes, you can move up,
down, and across vertical surfaces and upside down
along ceilings, while leaving your hands free. You have a
climbing speed equal to your walking speed. However,
the slippers don't allow you to move this way on a slippery
surface, such as one covered by ice or oil.

### Sovereign Glue

_Wondrous Item, Legendary; 25,000 gp_

This viscous, milky-white substance can form a permanent
bond between any two objects. It must be stored in a jar
or flask that has been coated inside with oil of slipperiness.
When found, a container contains 1d6 + 1 ounces.
One ounce of the glue can cover a 1-foot square surface.
The glue takes 1 minute to set. Once it has done so, the
bond it creates can be broken only by the application of
universal solvent or oil of etherealness, or with a wish spell.

### Spellguard Shield

_Armor (Shield), Very Rare (Requires Attunement); 60,000 gp_

While wielding this shield, you have advantage on saves
against spells and other magical effects, and spell attacks
have disadvantage against you.

### Spell Scroll

_Scroll, Rarity Varies; Price Varies_

A spell scroll bears the words of a single spell, written in a
mystical cipher. You can read the scroll and cast its spell
without providing any material components. Casting
the spell by reading the scroll requires the spell’s normal
casting time. Once the spell is cast, the words on the scroll
fade, and it crumbles to dust. If the casting is interrupted,
the scroll is not lost.

If the spell is on your source’s spell list but of a higher
circle than you can normally cast, you must make an ability
check using your spellcasting ability to determine whether
you cast it successfully. The DC equals 10 + the spell’s circle.
On a failed check, the spell disappears from the scroll with
no other effect.

The circle of the spell on the scroll determines the spell’s
save DC and attack bonus, as well as the scroll’s rarity, as
shown in the Spell Scroll Rarity table.

An Arcane circle spell on a spell scroll can be copied just as
spells in spellbooks can be copied. When a spell is copied
from a spell scroll, the copier must succeed on an INT
(Arcana) check with a DC equal to 10 + the spell’s circle.
If the check succeeds, the spell is successfully copied.
Whether the check succeeds or fails, the spell scroll is
destroyed.

#### Table: Spell Scroll Rarity

| SPELL CIRCLE | RARITY    | SAVE DC | ATTACK BONUS |     PRICE |
| ------------ | --------- | ------: | -----------: | --------: |
| Cantrip      | Common    |      13 |           +5 |     10 gp |
| 1st          | Common    |      13 |           +5 |     50 gp |
| 2nd          | Uncommon  |      13 |           +5 |    100 gp |
| 3rd          | Uncommon  |      15 |           +7 |    200 gp |
| 4th          | Rare      |      15 |           +7 |    350 gp |
| 5th          | Rare      |      17 |           +9 |    650 gp |
| 6th          | Very Rare |      17 |           +9 |  1,500 gp |
| 7th          | Very Rare |      18 |          +10 |  2,500 gp |
| 8th          | Very Rare |      18 |          +10 |  5,000 gp |
| 9th          | Legendary |      19 |          +11 | 10,500 gp |

### Staff of Fire

_Staff, Very Rare (Requires Attunement by a Druid, Sorcerer, Warlock, or Wizard); 63,500 gp_

You have resistance to cold damage while you hold this staff.
The staff has 10 charges. While holding it, you can use an
action to expend 1 or more of its charges to cast one of the
following spells from it, using your spell save DC: cone of
cold (5 charges), fog cloud (1 charge), ice storm (4 charges), or
wall of ice (4 charges).

### Staff of Healing

_Staff, Rare (Requires Attunement by a Bard, Cleric, or Druid); 22,500 gp_

### Staff of Power

_Staff, Very Rare (Requires Attunement by a Sorcerer, Warlock, or Wizard); 125,000 gp_

This staff can be wielded as a magic quarterstaff that
grants a +2 bonus to attack and damage rolls made with
it. While holding it, you gain a +2 bonus to AC, saves, and
spell attack rolls.

The staff has 20 charges and regains 2d8 + 4 expended
charges daily at dawn. If you expend the last charge, roll
a d20. On a 1, the staff retains its +2 bonus to attack and
damage rolls but loses all other properties. On a 20, the
staff regains 1d8 + 2 charges. The staff has the following
additional properties:

**_Power Strike._** When you hit with a melee attack using the
staff, you can expend 1 charge as part of your Attack action
to deal an extra 1d6 force damage to the target.

**_Spells._** While holding this staff, you can use an action to
expend 1 or more of its charges to cast one of the following
spells from it, using your spell save DC and spell attack
bonus: _cone of cold_ (5 charges), _fireball_ (5th-circle version,
5 charges), _globe of invulnerability_ (6 charges), _greater
hold_ (5 charges), _levitate_ (2 charges), _lightning bolt_ (5th-
circle version, 5 charges), _magic missile_ (1 charge),
_ray of enfeeblement_ (1 charge), or _wall of force_ (5 charges).

**_Retributive Strike._** You can use an action to break the
staff over your knee or against a solid surface, performing
a retributive strike. The staff is destroyed and releases its
remaining magic in an explosion that expands to fill a
30-foot-radius sphere centered on it.

You have a 50 percent chance to instantly travel to a
random plane of existence, avoiding the explosion. If you
fail to avoid the effect, you take force damage equal to 16 ×
the number of charges in the staff.

Every other creature in the area must make a DC 17
DEX save. On a failed save, a creature takes an amount
of damage based on how far away it is from the point of
origin, as shown in the following table. On a successful
save, a creature takes half as much damage.

#### Table: Retributive Strike Damage

| DISTANCE FROM ORIGIN  | DAMAGE                                 |
| --------------------- | -------------------------------------- |
| 10 ft. away or closer | 8 × the number of charges in the staff |
| 11 to 20 ft. away     | 6 × the number of charges in the staff |
| 21 to 30 ft. away     | 4 × the number of charges in the staff |

### Staff of Striking

_Staff, Very Rare (Requires Attunement); 66,000 gp_

This staff can be wielded as a magic quarterstaff that
grants a +3 bonus to attack and damage rolls made with it.
The staff has 10 charges. When you hit with a melee attack
using it, you can expend up to 3 of its charges as part of
your Attack action. For each charge you expend, the target
takes an extra 1d6 force damage.
The staff regains 1d6 + 4 expended charges daily at dawn.
If you expend the last charge, roll a d20. On a 1, the staff
becomes a nonmagical quarterstaff.
Staff of Swarming Insects

### Staff of Swarming Insects

_Staff, Rare (Requires Attunement by a Bard, Cleric, Druid, Sorcerer,; Warlock, or Wizard); 15,300 gp_

This staff has 10 charges and regains 1d6 + 4 expended
charges daily at dawn. If you expend the last charge, roll
a d20. On a 1, a swarm of insects consumes and destroys
the staff, then disperses. The staff has the following
additional properties:

**_Spells._** While holding the staff, you can use an action to
expend some of its charges to cast one of the following
spells from it, using your spell save DC: giant insect (4
charges) or insect plague (5 charges).

**_Insect Cloud._** While holding the staff, you can use an
action and expend 1 charge to cause a swarm of harmless
flying insects to spread out in a 30‑foot radius from you.
The insects remain for 10 minutes, making the area heavily
obscured for creatures other than you. The swarm moves
with you, remaining centered on you. A wind of at least 10
miles per hour disperses the swarm and ends the effect.

### Staff of the Magi

_Staff, Legendary (Requires Attunement by a Sorcerer, Warlock, or Wizard); Priceless_

This staff can be wielded as a magic quarterstaff that
grants a +2 bonus to attack and damage rolls made with it.
While you hold it, you gain a +2 bonus to spell attack rolls.

The staff has 50 charges and regains 4d6 + 2 expended
charges daily at dawn. If you expend the last charge, roll a
d20. On a 20, the staff regains 1d12 + 1 charges. The staff
has the following additional properties:

**_Spell Absorption._** While holding the staff, you have
advantage on saves against spells. In addition, you can
use your reaction when another creature casts a spell that
targets only you. If you do, the staff absorbs the magic
of the spell, canceling its effect and gaining a number of
charges equal to the absorbed spell's circle. However, if
doing so brings the staff 's total number of charges above
50, the staff explodes as if you activated its retributive strike
(see below).

**_Spells._** While holding the staff, you can use an action to
expend some of its charges to cast one of the following
spells from it, using your spell save DC and spellcasting
ability: _conjure elemental_ (7 charges), _dispel magic_ (3 charges),
_fireball_ (7th-circle version, 7 charges), _flaming sphere_ (2
charges), _ice storm_ (4 charges), _invisibility_ (2 charges), _knock_
(2 charges), _lightning bolt_ (7th-circle version, 7 charges),
_passwall_ (5 charges), _plane shift_ (7 charges), _telekinesis_ (5
charges), _wall of fire_ (4 charges), or _web_ (2 charges).

You can also use an action to cast one of the following
spells from the staff without using any charges: _arcane lock_,
_detect magic_, _enlarge/reduce_, _light_, _mage hand_,
or _protection from evil and good_.

**_Retributive Strike._** You can use an action to break the
staff over your knee or against a solid surface, performing
a retributive strike. The staff is destroyed and releases its
remaining magic in an explosion that expands to fill a
30‑foot‑radius sphere centered on it.

You have a 50 percent chance to instantly travel to a
random plane of existence, avoiding the explosion. If you
fail to avoid the effect, you take force damage equal to 16 ×
the number of charges in the staff.

Every other creature in the area must make a DC 17
DEX save. On a failed save, a creature takes an amount
of damage based on how far away it is from the point of
origin, as shown in the following table. On a successful
save, a creature takes half as much damage.

#### Table: Retributive Strike Damage

| DISTANCE FROM ORIGIN  | DAMAGE                                 |
| --------------------- | -------------------------------------- |
| 10 ft. away or closer | 8 × the number of charges in the staff |
| 11 to 20 ft. away     | 6 × the number of charges in the staff |
| 21 to 30 ft. away     | 4 × the number of charges in the staff |

### Staff of the Python

_Staff, Uncommon (Requires Attunement by a Cleric, Druid, or Wizard); Staff of Withering_
_; 2,000 gp_

You can use an action to speak this staff 's command word
and throw the staff on the ground within 10 feet of you.
The staff becomes a giant constrictor snake under your
control and acts on its own initiative count. By using a
bonus action to speak the command word again, you
return the staff to its normal form in a space formerly
occupied by the snake.

On your turn, you can mentally command the snake if it
is within 60 feet of you and you aren't incapacitated. You
decide what action the snake takes and where it moves
during its next turn, or you can issue it a general command,
such as to attack your enemies or guard a location.

If the snake is reduced to 0 HP, it dies and reverts to
its staff form. The staff then shatters and is destroyed. If
the snake reverts to staff form before losing all its HP, it
regains all of them.

### Staff of the Woodlands

_Staff, Rare (Requires Attunement by a Druid); 15,300 gp_

This staff can be wielded as a magic quarterstaff that
grants a +2 bonus to attack and damage rolls made with it.
While carrying it, you have a +2 bonus to spell attack rolls.
The staff has 10 charges. The staff has the following
additional properties:
Spells. You can use an action to expend 1 or more of the
staff 's charges to cast one of the following spells from
it, using your spell save DC: animal friendship (1 charge),
awaken (5 charges), barkskin (2 charges), locate animals or
plants (2 charges), speak with animals (1 charge), speak with
plants (3 charges), or wall of thorns (6 charges).
You can also use an action to cast the pass without trace
spell from the staff without expending any charges.
Tree Form. You can use an action to plant one end of the
staff in fertile earth and expend 1 charge to transform the
staff into a healthy tree. The tree is 60 feet tall and has a
5-foot-diameter trunk, and its branches at the top spread
out in a 20‑foot radius.
The tree appears ordinary but radiates a faint aura of
transmutation magic if targeted by detect magic. While
touching the tree and using another action to speak its
command word, you return the staff to its normal form.
Any creature in the tree falls when it reverts to a staff.
The staff regains 1d6 + 4 expended charges daily at dawn.
If you expend the last charge, roll a d20. On a 1, the staff
loses its properties and becomes a nonmagical quarterstaff.

### Staff of Thunder and Lightning

_Staff, Very Rare (Requires Attunement); 120,000 gp_

This staff can be wielded as a magic quarterstaff that
grants a +2 bonus to attack and damage rolls made with it.
The staff has the following additional properties:
Lightning. When you hit with a melee attack using the
staff, you can choose (no action required) to deal an extra
2d6 lightning damage to the target.
Thunder. When you hit with a melee attack using the staff,
you can choose (no action required) for the staff to emit
a crack of thunder, audible to 300 feet. The target you hit
must succeed on a DC 17 CON save or become stunned
until the end of your next turn.
Lightning Strike. You can use an action to cause a bolt of
lightning to leap from the staff 's tip in a line that is 5 feet
wide and 120 feet long. Each creature in that line must
make a DC 17 DEX save, taking 9d6 lightning damage on a
failed save, or half as much damage on a successful one.
Thunderclap. You can use an action to cause the staff to
issue a deafening thunderclap, audible to 600 feet. Each
creature within 60 feet of you (not including you) must
make a DC 17 CON save. On a failed save, a creature takes
2d6 thunder damage and is deafened for 1 minute. On a
successful save, it takes half damage and isn't deafened.
Thunder and Lightning. You can use an action to use
the Lightning Strike and Thunderclap properties at the
same time. Doing so doesn't expend the daily use of those
properties, only the use of this one.
When one of these properties is used, it can't be used
again until the next dawn.

### Staff of Withering

_Staff, Rare (Requires Attunement by a Cleric, Druid, or Warlock); 8,800 gp_

This staff has 3 charges and regains 1d3 expended charges
daily at dawn.

The staff can be wielded as a magic quarterstaff. On a
hit, it deals damage as a normal quarterstaff, and you can
expend 1 charge as part of your Attack action to deal an
extra 2d10 necrotic damage to the target. In addition,
the target must succeed on a DC 15 CON save or have
disadvantage for 1 hour on any ability check or save that
uses STR or CON.

### Stone of Controlling Earth Elements

_Wondrous Item, Rare; 14,500 gp_

This carved stone weighs 5 pounds. If the stone is
touching the ground, you can use an action to speak its
command word and summon an earth elemental, as if
you had cast the conjure elemental spell. The stone can't be
used this way again until the next dawn.

### Stone of Good Luck (Luckstone)

_Wondrous Item, Uncommon (Requires Attunement); Sword of Wounding_
_; 2,000 gp_

While carrying this polished agate, you gain a +1 bonus to
ability checks and saves.

### Sun Blade

_Weapon (Longsword), Rare (Requires Attunement); 8,000 gp_

This item appears to be a longsword hilt. While grasping
the hilt, you can use a bonus action to cause a blade of
pure radiance to spring into existence, or make the blade
disappear. While the blade exists, this magic longsword
has the Finesse property. If you are proficient with
shortswords or longswords, you are proficient with a
sun blade. You gain a +2 bonus to attack and damage rolls
made with this weapon, which deals radiant damage
instead of slashing damage. When you hit an Undead with
it, the target takes an extra 1d8 radiant damage.

The sword's luminous blade emits bright light in a 15‑foot
radius and dim light for an additional 15 feet. The light is
sunlight. While the blade persists, you can use an action to
expand or reduce its radius of bright and dim light by 5 feet
each, to a maximum of 30 feet each or a minimum of 10
feet each.

### Sword of Life Stealing

_Weapon (Any Sword), Rare (Requires Attunement); 8,000 gp_

When you attack a creature with this magic weapon and
roll a 20 on the attack roll, that target takes an extra
3d6 necrotic damage, provided that the target isn't a
Construct or an Undead. You gain temporary HP equal to
the extra damage dealt.

### Sword of Sharpness

_Weapon (Any Sword That Deals Slashing Damage), Very Rare (Requires Attunement); 60,000 gp_

When you attack an object with this magic sword and hit,
maximize your weapon damage dice against the target.

When you attack a creature with this weapon and roll a 20
on the attack roll, that target takes an extra 4d6 slashing
damage. Then roll another d20. If you roll a 20, you lop
off one of the target's limbs, with the effect of such loss
determined by the GM. If the creature has no limb to sever,
you lop off a portion of its body instead.

In addition, you can speak the sword's command word to
cause the blade to shed bright light in a 10-foot radius and
dim light for an additional 10 feet. Speaking the command
word again or sheathing the sword puts out the light.

This tube holds milky liquid with a strong alcohol smell.
You can use an action to pour its contents onto a surface
within reach. The liquid instantly dissolves up to 1 square
foot of adhesive it touches, including sovereign glue.

### Trident of Fish Command

_Weapon (Trident), Uncommon (Requires Attunement); 2,040 gp_

This trident is a magic weapon. It has 3 charges and
regains 1d3 expended charges daily at dawn. While you
carry it, you can use an action and expend 1 charge to cast
dominate (save DC 15) from it on a Beast that has an innate
swimming speed.

### Universal Solvent

_Wondrous Item, Legendary; 10,500 gp_

When you attack a creature with this magic weapon and
roll a 20 on the attack roll, that target takes an extra
3d6 necrotic damage, provided that the target isn't a
Construct or an Undead. You gain temporary HP equal to
the extra damage dealt.

### Vicious Weapon

_Weapon (Any), Very Rare; 1,500 gp + base weapon cost_

When you roll a 20 on your attack roll with this magic
weapon, your critical hit deals an extra 2d6 damage of the
weapon's type to the target.

### Vorpal Sword

_Weapon (Any Sword That Deals Slashing Damage), Legendary (Requires Attunement); 50,000 gp_

You gain a +3 bonus to attack and damage rolls made
with this magic weapon. In addition, the weapon ignores
resistance to slashing damage.

When you attack a creature that has at least one head
with this weapon and roll a 20 on the attack roll, you cut
off one of the creature's heads. The creature dies if it can't
survive without the lost head. A creature is immune to
this effect if it is immune to slashing damage, doesn't have
or need a head, has legendary actions, or the GM decides
that the creature is too big for its head to be cut off with
this weapon. Such a creature instead takes an extra 6d8
slashing damage from the hit.

### Wand of Binding

_Wand, Rare (Requires Attunement by a Spellcaster); 10,900 gp_

This wand has 7 charges and regains 1d6 + 1 expended
charges daily at dawn. If you expend the wand's last
charge, roll a d20. On a 1, it crumbles into ashes and
is destroyed. The wand has the following additional
properties:

**_Spells._** While holding the wand, you can use an action to
expend some of its charges to cast one of the following
spells (save DC 17): greater hold (5 charges) or hold (2
charges).

**_Assisted Escape._** While holding the wand, you can use your
reaction to expend 1 charge and gain advantage on a save
you make to avoid being paralyzed or restrained, or you can
expend 1 charge and gain advantage on any check you make
to escape a grapple.

### Wand of Enemy Detection

_Wand, Rare (Requires Attunement); 4,400 gp_

This wand has 7 charges. While holding it, you can use
an action and expend 1 charge to speak its command
word. For the next minute, you know the direction of the
nearest creature hostile to you within 60 feet, but not its
distance from you. The wand can sense the presence of
hostile creatures that are ethereal, invisible, disguised, or
hidden, as well as those in plain sight. The effect ends if
you stop holding the wand.

The wand regains 1d6 + 1 expended charges daily at dawn.
If you expend the wand's last charge, roll a d20. On a 1, the
wand crumbles into ashes and is destroyed.

### Wand of Fireballs

_Wand, Rare (Requires Attunement by a Spellcaster); 10,000 gp_

This wand has 7 charges. While holding it, you can use
an action to expend 1 or more of its charges to cast the
fireball spell (save DC 15) from it. For 1 charge, you cast the
3rd-circle version of the spell. You can increase the spell
slot circle by one for each additional charge you expend.

The wand regains 1d6 + 1 expended charges daily at dawn.
If you expend the wand's last charge, roll a d20. On a 1, the
wand crumbles into ashes and is destroyed.

### Wand of Lightning Bolts

_Wand, Rare (Requires Attunement by a Spellcaster); 10,000 gp_

This wand has 7 charges. While holding it, you can use
an action to expend 1 or more of its charges to cast the
lightning bolt spell (save DC 15) from it. For 1 charge, you
cast the 3rd-circle version of the spell. You can increase
the spell slot circle by one for each additional charge you
expend.

The wand regains 1d6 + 1 expended charges daily at dawn.
If you expend the wand's last charge, roll a d20. On a 1, the
wand crumbles into ashes and is destroyed.

### Wand of Magic Detection

_Wand, Uncommon; 1,000 gp_

This wand has 3 charges. While holding it, you can expend
1 charge as an action to cast the detect magic spell from it.
The wand regains 1d3 expended charges daily at dawn.

### Wand of Magic Missiles

_Wand, Uncommon; 1,000 gp_

This wand has 7 charges. While holding it, you can use an
action to expend 1 or more of its charges to cast the _magic
missile_ spell from it. For 1 charge, you cast the 1st-circle
version of the spell. You can increase the spell slot circle by
one for each additional charge you expend.

The wand regains 1d6 + 1 expended charges daily at dawn.
If you expend the wand's last charge, roll a d20. On a 1, the
wand crumbles into ashes and is destroyed.

### Wand of Paralysis

_Wand, Rare (Requires Attunement by a Spellcaster); 4,400 gp_

This wand has 7 charges. While holding it, you can use an
action to expend 1 of its charges to cause a thin blue ray to
streak from the tip toward a creature you can see within
60 feet of you. The target must succeed on a DC 15 CON
save or be paralyzed for 1 minute. At the end of each of the
target's turns, it can repeat the save, ending the effect on
itself on a success.

The wand regains 1d6 + 1 expended charges daily
at dawn. If you expend the wand's last charge, roll a d20.
On a 1, the wand crumbles into ashes and is destroyed.

### Wand of Polymorph

_Wand, Very Rare (Requires Attunement by a Spellcaster); 18,500 gp_

This wand has 7 charges. While holding it, you can use an
action to expend 1 of its charges to cast the polymorph spell
(save DC 15) from it.

The wand regains 1d6 + 1 expended charges daily at dawn.
If you expend the wand's last charge, roll a d20. On a 1, the
wand crumbles into ashes and is destroyed.

### Wand of Secrets

_Wand, Uncommon; 550 gp_

This wand has 3 charges. While holding it, you can use an
action to expend 1 of its charges, and if a secret door or
trap is within 30 feet of you, the wand pulses and points
at the one nearest to you. The wand regains 1d3 expended
charges daily at dawn.

### Wand of the War Mage, +1, +2, or +3

_Wand, Rarity Varies (Requires Attunement by a Spellcaster); Price Varies_

While holding this wand, you gain a bonus to spell attack
rolls determined by the wand's rarity. In addition, you
ignore half cover when making a spell attack.

#### Table: Wand Of The War Mage Rarity

| BONUS | RARITY    |                      PRICE |
| ----: | --------- | -------------------------: |
|    +1 | Uncommon  |  1,000 gp + wand base cost |
|    +2 | Rare      |  5,000 gp + wand base cost |
|    +3 | Very Rare | 15,000 gp + wand base cost |

### Wand of Web

_Wand, Uncommon (Requires Attunement by a Spellcaster); 3,000 gp_

This wand has 7 charges. While holding it, you can use an
action to expend 1 of its charges to cast the web spell (save
DC 15) from it.
The wand regains 1d6 + 1 expended charges daily at dawn.
If you expend the wand's last charge, roll a d20. On a 1, the
wand crumbles into ashes and is destroyed.

### Wand of Wonder

_Wand, Rare (Requires Attunement by a Spellcaster); 19,600 gp_

This wand has 7 charges. While holding it, you can use
an action to expend 1 of its charges and choose a target
within 120 feet of you. The target can be a creature, an
object, or a point in space. Roll d100 and consult the
following table to discover what happens.

If the effect causes you to cast a spell from the wand,
the spell's save DC is 15. If the spell normally has a range
expressed in feet, its range becomes 120 feet.

If an effect covers an area, you must center the spell on and
include the target. If an effect has multiple possible subjects,
the GM randomly determines which ones are affected.

The wand regains 1d6 + 1 expended charges daily at dawn.
If you expend the wand's last charge, roll a d20. On a 1, the
wand crumbles into dust and is destroyed.

| D100 | Effect |
|------|--------|
| 01–05 | You cast slow. |
| 06–10 | You cast faerie fire. |
| 11–15 | You are stunned until the start of your next turn, believing something awesome just happened. |
| 16–20 | You cast gust of wind. |
| 21–25 | You cast detect thoughts on the target you chose. If you didn't target a creature, you instead take 1d6 psychic damage. |
| 26–30 | You cast stinking cloud. |
| 31–33 | Rain falls in a 60-foot radius centered on the target. The area becomes lightly obscured. The rain falls until the start of your next turn. |
| 34–36 | An animal appears in the unoccupied space nearest the target. The animal isn't under your control and acts as it normally would. Roll a d100: on a 01–25, a rhinoceros appears; on a 26–50, an elephant appears; and on a 51–100, a rat appears. |
| 37–46 | You cast lightning bolt. |
| 47–49 | A cloud of 600 oversized butterflies fills a 30-foot radius centered on the target. The area becomes heavily obscured. The butterflies remain for 10 minutes. |
| 50–53 | You enlarge the target as if you had cast enlarge/reduce. If the target can't be affected by that spell, or if you didn't target a creature, you become the target. |
| 54–58 | You cast darkness. |
| 59–62 | Grass grows on the ground in a 60-foot radius centered on the target. If grass is already there, it grows to ten times its normal size and remains overgrown for 1 minute. |
| 63–65 | An object of the GM's choice disappears into the Ethereal Plane. The object must be neither worn nor carried, within 120 feet of the target, and no larger than 10 feet in any dimension. |
| 66–69 | You shrink as if you had cast enlarge/reduce on yourself. |
| 70–79 | You cast fireball. |
| 80–84 | You cast invisibility on yourself. |
| 85–87 | Leaves grow from the target. If you chose a point in space as the target, leaves sprout from the creature nearest to that point. Unless they are picked off, the leaves turn brown and fall off after 24 hours. |
| 88–90 | A stream of 1d4 × 10 gems, each worth 1 gp, shoots from the wand's tip in a line 30 feet long and 5 feet wide. Each gem deals 1 bludgeoning damage, and the total damage of the gems is divided equally among all creatures in the line. |
| 91–95 | A burst of colorful shimmering light extends from you in a 30-foot radius. You and each creature in the area that can see must succeed on a DC 15 CON save or become blinded for 1 minute. A creature can repeat the save at the end of each of its turns, ending the effect on itself on a success. |
| 96–97 | The target's skin turns blue for 1d10 days. If you chose a point in space, the creature nearest to that point is affected. |
| 98–100 | If you targeted a creature, it must make a DC 15 CON save. If you didn't target a creature, you become the target and must make the save. If the save fails by 5 or more, the target is instantly petrified. On any other failed save, the target is restrained and begins to turn to stone. While restrained in this way, the target must repeat the save at the end of its next turn, becoming petrified on a failure or ending the effect on a success. The petrification lasts until the target is freed by the greater restoration spell or similar magic. |

### Weapon, +1, +2, or +3

_Weapon (Any), Rarity Varies; Price Varies_

You have a bonus to attack and damage rolls made with
this magic weapon. The bonus is determined by the
weapon's rarity.

#### Table: Weapon Rarity

| BONUS | RARITY    |                        PRICE |
| ----: | --------- | ---------------------------: |
|    +1 | Uncommon  |  1,000 gp + weapon base cost |
|    +2 | Rare      |  5,000 gp + weapon base cost |
|    +3 | Very Rare | 15,000 gp + weapon base cost |

### Wind Fan

_Wondrous Item, Uncommon; 3,000 gp_

While holding this fan, you can use an action to cast the
gust of wind spell (save DC 13) from it. Once used, the
fan shouldn't be used again until the next dawn. Each
time it is used again before then, it has a cumulative 20
percent chance of not working and tearing into useless,
nonmagical tatters.

### Winged Boots

_Wondrous Item, Uncommon (Requires Attunement); 8,000 gp_

While you wear these boots, you have a flying speed equal
to your walking speed. You can use the boots to fly for up
to 4 hours, all at once or in several shorter flights, each
one using a minimum of 1 minute from the duration. If
you are flying when the duration expires, you descend at a
rate of 30 feet per round until you land.

The boots regain 2 hours of flying capability for every 12
hours they aren't in use.

### Wings of Flying

_Wondrous Item, Rare (Requires Attunement); 8,000 gp_

While wearing this cloak, you can use an action to speak
its command word. This turns the cloak into a pair of bat
wings or bird wings on your back for 1 hour or until you
repeat the command word as an action. The wings give
you a flying speed of 60 feet. When they disappear, you
can't use them again for 1d12 hours.

